﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["data"] == null)
        {
            Session["data"] = GetDataSource();
        }
        grid.DataSource = GetDataSource();
    }

    public DataTable GetDataSource()
    {
        DataTable dt = new DataTable("Table");
        dt.Columns.Add("id");
        dt.Columns.Add("Number");
        dt.Columns.Add("Date");

        dt.Columns["Number"].DataType = Type.GetType("System.Int32");
        DataColumn[] PrimaryKeyColumns = new DataColumn[1];
        PrimaryKeyColumns[0] = dt.Columns["id"];
        dt.PrimaryKey = PrimaryKeyColumns;

        for (int i = 0; i <= 35; i++)
        {
            dt.Rows.Add(new object[] { i, i + 25, DateTime.Now });
        }
        return dt;
    }
}