﻿using Infragistics.Web.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace igGridDataSourceАfterRESTBind.Controllers
{
    public class HomeController : Controller
    {
        static Models.DataUtils data = new Models.DataUtils();

        public ActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public ActionResult GetData(int page, int pageSize)
        {
            LargeJsonResult result = new LargeJsonResult();
            Dictionary<string, object> response = new Dictionary<string, object>();
            response.Add("Records", data.Products.AsQueryable().Skip(page * pageSize).Take(pageSize));
            response.Add("TotalRecordsCount", data.Products.Count());
            result.Data = response;
            return result;
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }
    }
}