﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace igGridDataSourceАfterRESTBind.Models
{
    public class DataUtils
    {
        #region private members

        #region private fields

        private List<Category> categories;
        private List<Product> products;
        private List<Category> categoriesAndProducts;

        #endregion private fields

        #region private methods

        private List<Category> CreateCategories()
        {
            return new List<Category>
            {
                new Category
                {
                    CategoryID = 1,
                    CategoryName = "Beverages",
                    Description = "Soft drinks, coffees, teas, beers, and ales"
                },

                new Category
                {
                    CategoryID = 2,
                    CategoryName = "Condiments",
                    Description = "Sweet and savory sauces, relishes, spreads, and seasonings"
                },

                new Category
                {
                    CategoryID = 3,
                    CategoryName = "Confections",
                    Description = "Desserts, candies, and sweet breads",
                },

                new Category
                {
                    CategoryID = 4,
                    CategoryName = "Dairy Product",
                    Description = "Cheeses",
                },

                new Category
                {
                    CategoryID = 5,
                    CategoryName = "Grains/Cereals",
                    Description = "Breads, crackers, pasta, and cereal",
                },

                new Category
                {
                    CategoryID = 6,
                    CategoryName = "Meat/Poultry",
                    Description = "Prepared meats",
                },

                new Category
                {
                    CategoryID = 7,
                    CategoryName = "Produce",
                    Description = "Dried fruit and bean curd",
                },

                new Category
                {
                    CategoryID = 8,
                    CategoryName = "Seafood",
                    Description = "Seaweed and fish",
                }
            };
        }

        private List<Product> CreateProducts()
        {
            List<Product> prods = new List<Product>();

            for (int i = 0; i < 500; ++i)
            {
                Product newProd = new Product
                {
                    ProductID = i,
                    ProductName = String.Format("Name {0}", i),
                    CategoryID = 1,
                    QuantityPerUnit = "10 boxes x 20 bags",
                    UnitPrice = 18.0000m,
                    UnitsInStock = 39,
                    UnitsOnOrder = 0,
                    ReorderLevel = 10,
                    Discontinued = false
                };

                prods.Add(newProd);
            }

            return prods;
        }

        private List<Category> CreateCategoriesAndProducts()
        {
            List<Category> retVal = CreateCategories();

            List<Product> tempProducts = CreateProducts();

            Category parentCategory = null;

            foreach (Product p in tempProducts)
            {
                if (parentCategory == null || parentCategory.CategoryID != p.CategoryID)
                {
                    parentCategory = retVal.First<Category>(category => category.CategoryID == p.CategoryID);
                }

                parentCategory.AddProduct(p);
            }

            return retVal;
        }

        #endregion private methods

        #endregion private members

        #region public members

        #region public properties

        public IQueryable<Category> Categories
        {
            get
            {
                if (categories == null)
                    categories = CreateCategories();

                return categories.AsQueryable<Category>();
            }
        }

        public IQueryable<Product> Products
        {
            get
            {
                if (products == null)
                    products = CreateProducts();

                return products.AsQueryable<Product>();
            }
        }

        public IQueryable<Category> CategoriesAndProducts
        {
            get
            {
                if (categoriesAndProducts == null)
                    categoriesAndProducts = CreateCategoriesAndProducts();

                return categoriesAndProducts.AsQueryable<Category>();
            }
        }

        #endregion public properties

        #region public methods

        public void AddProduct(Product newProd)
        {
            products.Add(newProd);
        }

        public void RemoveProduct(Product remProd)
        {
            products.Remove(remProd);
        }

        public void UpdateProduct(Product updateProd)
        {
            Product product = (from p in this.Products
                               where p.ProductID == updateProd.ProductID
                               select p).Single();

            product.CategoryID = updateProd.CategoryID;
            product.Discontinued = updateProd.Discontinued;
            product.ProductName = updateProd.ProductName;
            product.QuantityPerUnit = updateProd.QuantityPerUnit;
            product.ReorderLevel = updateProd.ReorderLevel;
            product.UnitPrice = updateProd.UnitPrice;
            product.UnitsInStock = updateProd.UnitsInStock;
            product.UnitsOnOrder = updateProd.UnitsOnOrder;
        }

        #endregion public methods

        #endregion public members
    }

    public class Category
    {
        #region private fields

        private int categoryID;
        private string categoryName;
        private string description;
        private List<Product> products;

        #endregion private fields

        #region Constructor

        public Category()
        {
            products = new List<Product>();
        }

        #endregion Constructor

        #region public properties

        public int CategoryID
        {
            get
            {
                return this.categoryID;
            }
            set
            {
                if (this.categoryID != value)
                {
                    this.categoryID = value;
                }
            }
        }

        public string CategoryName
        {
            get
            {
                return this.categoryName;
            }
            set
            {
                if (this.categoryName != value)
                {
                    this.categoryName = value;
                }
            }
        }

        public string Description
        {
            get
            {
                return this.description;
            }
            set
            {
                if (this.description != value)
                {
                    this.description = value;
                }
            }
        }

        public IQueryable<Product> Products
        {
            get
            {
                return this.products.AsQueryable<Product>();
            }
        }

        #endregion public properties

        #region public methods

        public void AddProduct(Product newProduct)
        {
            products.Add(newProduct);
        }

        #endregion public methods
    }

    public class Product
    {
        #region private members

        private int productID;
        private string productName;
        private int categoryID;
        private string quantityPerUnit;
        private decimal unitPrice;
        private int unitsInStock;
        private int unitsOnOrder;
        private int reorderLevel;
        private bool discontinued;

        #endregion private members

        #region public properties

        public int ProductID
        {
            get
            {
                return this.productID;
            }
            set
            {
                if (this.productID != value)
                {
                    this.productID = value;
                }
            }
        }

        public string ProductName
        {
            get
            {
                return this.productName;
            }
            set
            {
                if (this.productName != value)
                {
                    this.productName = value;
                }
            }
        }

        public int CategoryID
        {
            get
            {
                return this.categoryID;
            }
            set
            {
                if (this.categoryID != value)
                {
                    this.categoryID = value;
                }
            }
        }

        public string QuantityPerUnit
        {
            get
            {
                return this.quantityPerUnit;
            }
            set
            {
                if (this.quantityPerUnit != value)
                {
                    this.quantityPerUnit = value;
                }
            }
        }

        public decimal UnitPrice
        {
            get
            {
                return this.unitPrice;
            }
            set
            {
                if (value < 0)
                    throw new Exception("Negative numbers are not allowed.");

                this.unitPrice = value;
            }
        }

        public int UnitsInStock
        {
            get
            {
                return this.unitsInStock;
            }
            set
            {
                if (value < 0)
                    throw new Exception("Negative numbers are not allowed.");

                this.unitsInStock = value;
            }
        }

        public int UnitsOnOrder
        {
            get
            {
                return this.unitsOnOrder;
            }
            set
            {
                if (this.unitsOnOrder != value)
                {
                    this.unitsOnOrder = value;
                }
            }
        }

        public int ReorderLevel
        {
            get
            {
                return this.reorderLevel;
            }
            set
            {
                if (this.reorderLevel != value)
                {
                    this.reorderLevel = value;
                }
            }
        }

        public bool Discontinued
        {
            get
            {
                return this.discontinued;
            }
            set
            {
                if (this.discontinued != value)
                {
                    this.discontinued = value;
                }
            }
        }

        #endregion public properties
    }
}