﻿using Infragistics.Web.Mvc;
using Microsoft.AspNetCore.Mvc;
using System.Data;

namespace IgApp.Controllers
{
    public class HomeController : Controller
    {
		[GridDataSourceAction]
		public ActionResult Index()
		{
			DataTable customers = this.GetCustomerDataTable();
			return View(customers);
		}

		private DataTable GetCustomerDataTable()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add("CustomerID", typeof(String));
			dt.Columns.Add("Region", typeof(String));
			dt.Columns.Add("Address", typeof(String));
			dt.Columns.Add("City", typeof(String));
			dt.Columns.Add("Fax", typeof(String));


			for (int i = 0; i < 4; i++)
			{
				DataRow row = dt.NewRow();
				row["CustomerID"] = "A" + i;
				row["Region"] = "Region" + i;
				row["Address"] = "Address Str." + i;
				row["City"] = i % 2 == 0 ? "Sofia" : "New York";
				row["Fax"] = "9425" + i;
				dt.Rows.Add(row);
			}
			return dt;
		}
	}
}