﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WebForm1.aspx.cs" Inherits="ColumnFormatStringSSN.WebForm1" %>

<%@ Register Assembly="Infragistics45.Web.v21.2, Version=21.2.20212.9, Culture=neutral, PublicKeyToken=7dd5c3163f2cd0cb" Namespace="Infragistics.Web.UI.GridControls" TagPrefix="ig" %>

<%@ Register Assembly="Infragistics45.Web.v21.2, Version=21.2.20212.9, Culture=neutral, PublicKeyToken=7dd5c3163f2cd0cb" Namespace="Infragistics.Web.UI" TagPrefix="ig" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <ig:WebScriptManager ID="WebScriptManager1" runat="server"></ig:WebScriptManager>
            <ig:WebDataGrid ID="WebDataGrid1" runat="server" Height="550px" Width="800px" AutoGenerateColumns="False" DataKeyFields="ID"
                 OnInitializeRow="WebDataGrid1_InitializeRow">
                 <Columns>
                    <ig:BoundDataField DataFieldName="ID" Key="ID" Header-CssClass="custom-header" >
                        <Header Text="Id">
                        </Header>
                    </ig:BoundDataField>
                    <ig:BoundDataField DataFieldName="Name" Key="Name">
                        <Header Text="Name" >
                        </Header>
                    </ig:BoundDataField>
                    <ig:BoundDataField Key="Date" DataFieldName="Date" DataType="System.DateTime">                        
                        <Header Text="Registration Date"/>
                    </ig:BoundDataField>
                     <ig:BoundDataField DataFieldName="SSN" Key="SSN">
                        <Header Text="SSN" >
                        </Header>
                    </ig:BoundDataField>
                </Columns>

                <EditorProviders>
                    <ig:MonthCalendarProvider ID="WebDataGrid1_MonthCalendarProvider1" >
                        <EditorControl ClientIDMode="Predictable">
                        </EditorControl>
                    </ig:MonthCalendarProvider>     
                    <ig:NumericEditorProvider ID="WebDataGrid1_NumericEditorProvider1">
                        <EditorControl ClientIDMode="Predictable" MaxLength="9">
                        </EditorControl>
                    </ig:NumericEditorProvider>
                </EditorProviders>

                <Behaviors>
                    <ig:Clipboard>
                    </ig:Clipboard>
                    <ig:Activation >
                    </ig:Activation>
                    <ig:Selection CellClickAction="Cell" CellSelectType="Multiple" RowSelectType="Multiple">
                    </ig:Selection>
                    <ig:EditingCore  EditingClientEvents-CellValueChanged="CellValueChanged" EditingClientEvents-CellValueChanging="CellValueChanging">
                        <Behaviors>
                            <ig:CellEditing EditModeActions-EnableOnActive="false">
                                 <ColumnSettings>
                                    <ig:EditingColumnSetting ColumnKey="ID" ReadOnly="True" />
                                    <ig:EditingColumnSetting ColumnKey="Date" EditorID="WebDataGrid1_MonthCalendarProvider1" /> 
                                     <ig:EditingColumnSetting ColumnKey="SSN" EditorID="WebDataGrid1_NumericEditorProvider1" />
                                    
                                     
                                </ColumnSettings>
                            </ig:CellEditing>                            
                        </Behaviors>
                    </ig:EditingCore>
                    <ig:RowSelectors>
                    </ig:RowSelectors>
                </Behaviors>              
            </ig:WebDataGrid>
        </div>
        <asp:Button ID="Button1" runat="server" Text="Button" />
    </form> 
    <script>
        function formatSocialSecurity(val) {
            val = val.toString();
            val = val.replace(/\D/g, '');
            val = val.replace(/^(\d{3})/, '$1-');
            val = val.replace(/-(\d{2})/, '-$1-');
            val = val.replace(/(\d)-(\d{4}).*/, '$1-$2');
            return val;
        }  

        function CellValueChanging(sender, e) {            
            var value = e.get_newValue();            
            if (value.toString().length < 9) {
                alert("Please enter a number with 9 digits in order to have a correct SSN format.")
                e.set_cancel(true);
            }
        }

        function CellValueChanged(sender, e) {
            var cell = e.get_cell();
            var value = cell.get_value();
            if (cell.get_column().get_key() === "SSN") {               
                cell.set_text(formatSocialSecurity(value));
            }

        }
    </script>
</body>
</html>
