﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace ColumnFormatStringSSN
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)

            {
                Session["DS"] = GetData();

            }

            this.WebDataGrid1.DataSource = (DataTable)Session["DS"];
        }

        private DataTable GetData()
        {
            string[] names = { "Peter", "Maria", "John", "Vladimir", "Gustavo" };

            DataTable dt = new DataTable();

            var keys = new DataColumn[1];

            dt.Columns.Add("ID", typeof(int));
            dt.Columns.Add("Name", typeof(string));
            dt.Columns.Add("Date", typeof(DateTime));
            dt.Columns.Add("SSN", typeof(int));

            for (int i = 0; i < 10; i++)
            {
                var row = dt.Rows.Add();
                row[0] = i + 1;
                row[1] = names[i % 5];
                row[2] = DateTime.Now.AddDays(i * 2);
                row[3] = 123456789;
            }
            keys[0] = dt.Columns["ID"];

            dt.PrimaryKey = keys;

            return dt;
        }

        protected void WebDataGrid1_InitializeRow(object sender, Infragistics.Web.UI.GridControls.RowEventArgs e)
        {
            e.Row.Items.FindItemByKey("SSN").Text = e.Row.Items.FindItemByKey("SSN").Value.ToString().Insert(5, "-").Insert(3, "-");
           
        }
    }
}