import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {

  public gridDataSource = [];

  public showContextMenu = false;
  public contextMenuX = 0;
  public contextMenuY = 0;
  public targetCell = null;

  public localData = [
    { Name: 'Alice', Age: '25'},
    { Name: 'Bob', Age: '26'},
    { Name: 'Chris', Age: '27'}
  ];

  public ngOnInit(): void {
    this.gridDataSource = this.localData;
  }

  public contextMenuHandler(eventArgs) {
    eventArgs.event.preventDefault();
    this.contextMenuX = eventArgs.event.clientX;
    this.contextMenuY = eventArgs.event.clientY;
    this.targetCell = eventArgs.cell;
    this.showContextMenu = true;
  }

  public hideContextMenu() {
    this.showContextMenu = false;
  }

}
