﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using System.Web.WebSockets;

namespace IgniteUIHTMLEditorExample.Controllers
{
    public class ScriptController : Controller
    {
        public ActionResult Index()
        {
            List<CRMScript> scripts = GetAllScripts();

            return View(scripts);
        }

        [HttpPost]
        public ActionResult Display(int id)
        {
            List<CRMScript> scripts = GetAllScripts();

            if (scripts != null)
            {
                var firstOrDefault = scripts.FirstOrDefault(s => s.ID == id);
                if (firstOrDefault != null)
                {
                    string script = firstOrDefault.Script;

                    if (script == null)
                    {
                        return Json(new {success = false}, "");
                    }

                    return Json(new {success = true, script});
                }

                return Json(new { success = false }, "");
            }

            return Json(new { success = false }, "");
        }

        private List<CRMScript> GetAllScripts()
        {
            List<CRMScript> scripts = new List<CRMScript>();

            for (int i = 1; i < 6; i++)
            {
                var script = new CRMScript
                {
                    ID = i,
                    Name = "Test Script Name " + i,
                    Description = "Test Script Description",
                    Script =
                        @"&lt;HTML&gt;
                        &lt;HEAD&gt;
                        &lt;TITLE&gt;Your Title Here&lt;/TITLE&gt;
                        &lt;/HEAD&gt;
                        &lt;BODY BGCOLOR=&quot;FFFFFF&quot;&gt;
                        &lt;CENTER&gt;&lt;IMG SRC=&quot;/images/IngenSLogo53x48.png&quot; ALIGN=&quot;BOTTOM&quot;&gt; &lt;/CENTER&gt;
                        &lt;HR&gt;
                        &lt;a href=&quot;http://somegreatsite.com&quot;&gt;Link Name&lt;/a&gt;
                        is a link to another nifty site
                        &lt;H1&gt;This is a Header&lt;/H1&gt;
                        &lt;H2&gt;This is a Medium Header&lt;/H2&gt;
                        Send me mail at &lt;a href=&quot;mailto:support@yourcompany.com&quot;&gt;
                        support@yourcompany.com&lt;/a&gt;.
                        &lt;P&gt; This is a new paragraph!
                        &lt;P&gt; &lt;B&gt;This is a new paragraph!&lt;/B&gt;
                        &lt;BR&gt; &lt;B&gt;&lt;I&gt;This is a new sentence without a paragraph break, in bold italics.&lt;/I&gt;&lt;/B&gt;
                        &lt;HR&gt;
                        &lt;/BODY&gt;
                        &lt;/HTML&gt;",
                    CheckList = "a,b,c",
                };

                scripts.Add(script);
            }

            return scripts;
        } 
    }
}