﻿using InfragisticsMvcApp1.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace InfragisticsMvcApp1.Controllers
{
	public class HomeController : Controller
	{
		public ActionResult GetDatePickerDateUsingFormCollection(FormCollection form2)
		{
			//accessing formCollection
			string dpValue = Request.Form["datePickerWithInputName"];
			var ckbValue = form2["Ckbx1"];
			ViewBag.dpValueVB = dpValue;
			ViewBag.ckbValueVB = ckbValue;
			return View();
		}

		//public ActionResult GetDatePickerDate(DateTime Birthdate, bool? CkbQuestion1)
		public ActionResult GetDatePickerDate(Customer customer)
		{
			string datePicker1SelectedDate = HttpContext.Request.Params.Get("Birthdate");
			//implement some custom logic either updating the existing model or else. 
			ViewBag.Date = datePicker1SelectedDate;
			ViewBag.myCustomerModel = customer;
			return View();
		}


		[AcceptVerbs(HttpVerbs.Get)]
		public ActionResult Index()
		{
			//This object will serve as the basis for binding to data
			//on the Index.cshtml View with the MVC Helpers. See:
			//@model = OctaneUIWebApplication5.Models.CustomersViewModel
			var viewModel = new CustomersViewModel
			{
				//IEnumerable of Customer Objects
				Customers = GetCustomers(),

				//IEnumerable of CustomerCountSummary Objects
				//For use with binding to the Chart
				CustomerCountSummaries = GetCustomerCounts()
			};

			return View(viewModel);
		}

		private IEnumerable<CustomerCountSummary> GetCustomerCounts()
		{
			var customers = GetCustomers();
			var active = from c in customers
						 where c.IsActive
						 select c;

			var inActive = from c in customers
						   where (c.IsActive == false)
						   select c;

			return new List<CustomerCountSummary> { 
                new CustomerCountSummary { CategoryLabel = "Active", CustomerCount = active.Count() },
                new CustomerCountSummary { CategoryLabel = "Inactive", CustomerCount = inActive.Count() }
            };
		}

		private IEnumerable<Customer> GetCustomers()
		{
			return new List<Customer>
            {
                new Customer { ID=1, Name="John Smith", IsActive=true, Birthdate=new System.DateTime(2020,12,05) },
                new Customer { ID=2, Name="Bob Richards", IsActive=false, Birthdate=new System.DateTime(2020,12,06) },
                new Customer { ID=3, Name="Marge Wright", IsActive=false,Birthdate=new System.DateTime(2020,12,07) },
                new Customer { ID=4, Name="Dwight Long", IsActive=true, Birthdate=new System.DateTime(2020,12,08) },
                new Customer { ID=5, Name="Amy Grant", IsActive=true, Birthdate=new System.DateTime(2020,12,09) },
            };
		}
	}
}
