﻿/*!@license
 * Infragistics.Web.ClientUI Grid Tooltips 13.1.20131.2523
 *
 * Copyright (c) 2011-2014 Infragistics Inc.
 *
 * http://www.infragistics.com/
 *
 * Depends on:
 *	jquery-1.4.3.js
 *	modernizr.js
 *	infragistics.ui.shared.js
 *	infragistics.ui.grid.framework.js
 */
if(typeof jQuery!=="function"){throw new Error("jQuery is undefined")}(function($){"use strict";$.widget("ui.igGridTooltips",{options:{visibility:"overflow",style:"tooltip",showDelay:500,hideDelay:300,columnSettings:[{columnKey:null,columnIndex:-1,allowTooltips:true}],fadeTimespan:150,cursorLeftOffset:10,cursorTopOffset:15},css:{tooltip:"ui-iggrid-tooltip",tooltipContent:"ui-iggrid-tooltip-content"},events:{tooltipShowing:"tooltipShowing",tooltipShown:"tooltipShown",tooltipHiding:"tooltipHiding",tooltipHidden:"tooltipHidden"},_createWidget:function(options,element){this.visible=false;this._canFadeIn=true;this._canFadeOut=true;$.Widget.prototype._createWidget.apply(this,arguments)},destroy:function(){this.grid.element.unbind(".tooltip");$("#"+this.id()+"_ruler").remove();this.tooltip.remove();$.Widget.prototype.destroy.call(this);return this},id:function(){return this.tooltip[0].id},_injectGrid:function(gridInstance,isRebind){if(isRebind===true){return}this.grid=gridInstance;this._createTooltip();this._createHandlers();this._unregisterGridEvents();this._registerGridEvents()},_createTooltip:function(){if(this.options.style==="tooltip"){this.tooltip=$("<div></div>").attr("id",this.grid.id()+"_tooltips").attr("role","tooltip").addClass("ui-tooltip").addClass("ui-widget").addClass("ui-corner-all").addClass("ui-widget-content").addClass(this.css.tooltip).css({position:"absolute",display:"none","white-space":"normal","word-wrap":"break-word"});this._createContainer()}else if(this.options.style==="popover"){this.tooltip=$("<div><div>").attr("id",this.grid.id()+"_tooltips").igPopover({fadeTimespan:this.options.fadeTimespan})}this._createRuler();this.tooltip.appendTo(document.body)},_createRuler:function(){$("<span></span>").attr("id",this.id()+"_ruler").css("display","none").css("white-space","normal").css("word-wrap","break-word").appendTo(document.body)},_createContainer:function(){$("<div></div>").attr("id",this.id()+"_container").addClass("ui-tooltip-content").addClass(this.css.tooltipContent).appendTo(this.tooltip).bind("mouseenter.tooltip",$.proxy(this._tooltipMouseEnter,this)).bind("mouseleave.tooltip",$.proxy(this._tooltipMouseLeave,this))},_displayOverflow:function(element){var ruler=$("#"+this.id()+"_ruler"),textHeightInPixels;ruler.text(element.text());ruler.css({"font-family":element.css("font-family"),"font-size":element.css("font-size"),"font-size-adjust":element.css("font-size-adjust"),"font-stretch":element.css("font-stretch"),"font-style":element.css("font-style"),"font-variant":element.css("font-variant"),"font-weight":element.css("font-weight"),"padding-left":element.css("padding-left"),"padding-top":element.css("padding-top"),"padding-right":element.css("padding-right"),"padding-bottom":element.css("padding-bottom")});ruler.width(element.width());textHeightInPixels=ruler.height();if(textHeightInPixels<=element.height()){return false}return true},_dataRendered:function(event,ui){var $tbody,$tbodyFixed;if(ui!==undefined){if($(ui.owner.element).attr("id")!==this.grid.id()){return}}$tbody=this.grid.element.children("tbody");this._registerMouseEvents($tbody);if(this.grid.hasFixedColumns()){$tbodyFixed=this.grid.fixedTable().find("tbody");this._registerMouseEvents($tbodyFixed)}if(this.grid.options.fixedHeaders===true){this._$thead=this.grid.headersTable().find("thead")}else{this._$thead=this.grid.container().find("#"+this.grid.id()+" thead")}},_rowsRendering:function(evt,args){var tbody;if(args.owner.id()!==this.grid.id()){return}tbody=this.grid.element.find("tbody");tbody.unbind("mouseleave.tooltip");tbody.unbind("mousemove.tooltip")},_rowsRendered:function(event,ui){var $tbody;if(ui!==undefined){if($(ui.owner.element).attr("id")!==this.grid.id()){return}}$tbody=this.grid.element.children("tbody");this._registerMouseEvents($tbody)},_registerMouseEvents:function(tbody){tbody.bind("mouseleave.tooltip",this._gridMouseLeaveHandler);tbody.bind("mousemove.tooltip",this._gridMouseMoveHandler)},_gridMouseLeave:function(event,ui){clearTimeout(this.timeoutShowing);clearTimeout(this.timeoutHiding);if(this.tooltip.css("display")!=="none"){this._hideTooltip(true)}this._currentlyHovered=null},_gridMouseMove:function(event,ui){var element=$(event.target).closest("td,th"),elementData,hidePrevious=true,shouldShow,hasFixedCols=this.grid.hasFixedColumns();if(element.closest("table").attr("id")!==this.grid.id()||hasFixedCols&&element.closest("table").attr("id")!==this.grid.id()+"_fixed"){return}this.mouseX=event.pageX;this.mouseY=event.pageY;if(element[0]===this._currentlyHovered||element.length===0){return}elementData=this._getElementValue(element);if(elementData===undefined){hidePrevious=true}if(element[0]===this._currentlyDisplayed&&this.visible===true){hidePrevious=false;clearTimeout(this.timeoutHiding);return}this._currentlyHovered=element[0];this._previouslyHoveredData=this._currentlyHoveredData;this._currentlyHoveredData=elementData;clearTimeout(this.timeoutShowing);shouldShow=this._shouldShowForTarget(element)&&elementData!==undefined&&elementData!==""&&$(event.target).attr("unselectable")===undefined;if(this.visible===true&&hidePrevious===true){this._hideTooltip(!shouldShow)}if(shouldShow===true){this._currentlyDisplayed=this._currentlyHovered;this._showTooltip()}},_tooltipMouseEnter:function(){clearTimeout(this.timeoutHiding)},_tooltipMouseLeave:function(){this._hideTooltip()},_getElementValue:function(element){var col,val,tlog,i,tid,row=element.closest("tr"),vrowidx=-1,$thead,hasFixedCols=this.grid.hasFixedColumns(),hskip=0;if(this.grid.options.virtualization||this.grid.options.columnVirtualization){hskip=this.grid._startColIndex||0}if(hasFixedCols){if(element.closest("div").attr("data-fixed-container")!==undefined){$thead=this.grid.fixedHeadersTable()}else{$thead=this.grid.headersTable()}col=$thead.find("thead th").eq(element.index()).data("columnIndex");col-=$thead.children("th[data-skip='true']").length;if(isNaN(col)){col=-1}}else{if(this._$thead.length>0){col=element.index()-this._$thead.children(":first").children("th[data-skip='true']").length+hskip}else{col=element.index()-element.parent().find("td[data-parent='true'],td[data-skip='true'],th").length+hskip}}if(col<0){return val}this._pRowIdx=this._rowIdx;this._rowIdx=element.closest("tbody").children("tr:not([data-container='true'],[data-grouprow='true'])").index(row);if(this.grid.options.virtualization||this.grid.options.rowVirtualization){if(this.grid.options.virtualizationMode==="fixed"){this._rowIdx+=this.grid._startRowIndex}else{vrowidx=parseInt(row.attr("data-row-idx"),10);this._rowIdx=vrowidx||this._rowIdx}}tlog=this.grid.dataSource.pendingTransactions();tid=parseInt(element.parent().attr("data-id"),10);for(i=tlog.length-1;i>=0;i--){if(tlog[i].type==="deleterow"){continue}if(tlog[i].type==="cell"){if(tlog[i].rowId===tid&&tlog[i].col===this.grid._visibleColumns()[col].key){val=tlog[i].value;break}}else{if(tlog[i].rowId===tid){val=tlog[i].row[this.grid._visibleColumns()[col].key];break}}}if(val===undefined&&this.grid.dataSource.dataView()[this._rowIdx]!==undefined){val=this.grid.dataSource.dataView()[this._rowIdx][this.grid._visibleColumns()[col].key]}if($.type(val)==="date"){if(this.grid.options.enableUTCDates===true){val=$.ig.formatter(val,"date","dateTime",true,this.grid.options.enableUTCDates)}}return val},_shouldShowForTarget:function(element){var shouldShow=true,realIdx,dataIdx,hasFixedColumns=this.grid.hasFixedColumns(),fixingDirection;switch(this.options.visibility){case"always":break;case"never":shouldShow=false;break;case"overflow":shouldShow=this._displayOverflow(element);break}if(shouldShow===false){return false}realIdx=element.index();dataIdx=element.parent().children("td:not([data-parent='true'],[data-skip='true'])").index(element);this._pColumnIdx=this._columnIdx;if(this.grid._isMultiColumnGrid){this._columnIdx=dataIdx}else{if(hasFixedColumns&&element.closest("[data-fixed-container]").length===1){this._columnIdx=this.grid.fixedHeadersTable().find("thead th[id]").not("[data-skip='true']").eq(dataIdx).data("columnIndex")}else{this._columnIdx=this._$thead.find("th[id]").not("[data-skip='true']").eq(dataIdx).data("columnIndex")}}if(this._columnIdx===undefined){this._columnIdx=realIdx}if(this._columnIdx<0||this._columnIdx>=this.grid.options.columns.length){return false}this._pColumnKey=this._columnKey;if(this.grid._isMultiColumnGrid){this._columnKey=this.grid._visibleColumns()[dataIdx].key}else{this._columnKey=this.grid.options.columns[this._columnIdx].key}return shouldShow&&this._shouldShowForColumn()},_shouldShowForColumn:function(){var i,colSettings=this.options.columnSettings;for(i=0;i<colSettings.length;i++){if(colSettings[i].columnKey===this._columnKey||colSettings[i].columnIndex===this._columnIdx){return colSettings[i].allowTooltips!==undefined?colSettings[i].allowTooltips:true}}return true},_hideTooltip:function(current){var self=this,args,fn;args={owner:this,tooltip:current===true?String(this._currentlyHoveredData):String(this._previouslyHoveredData),value:current===true?this._currentlyHoveredData:this._previouslyHoveredData,element:this._currentlyDisplayed,columnKey:current===true?this._columnKey:this._pColumnKey,index:current===true?this._rowIdx:this._pRowIdx,columnIndex:current===true?this._columnIdx:this._pColumnIdx};fn=function(){var noCancel=self._trigger(self.events.tooltipHiding,self,args);if(noCancel===true){self._hideTooltipNoDelay();self._trigger(self.events.tooltipHidden,self,args)}};if(typeof Modernizr==="object"&&Modernizr.touch===true){fn()}else{clearTimeout(this.timeoutHiding);this.timeoutHiding=setTimeout(fn,this.options.hideDelay)}},_showTooltip:function(){var self=this,args,fn;args={owner:this,tooltip:String(this._currentlyHoveredData),value:this._currentlyHoveredData,element:this._currentlyDisplayed,columnKey:this._columnKey,index:this._rowIdx,columnIndex:this._columnIdx};fn=function(){var noCancel=self._trigger(self.events.tooltipShowing,self,args);if(noCancel===true){self._showTooltipNoDelay(args.tooltip);self._trigger(self.events.tooltipShown,self,args)}};if(typeof Modernizr==="object"&&Modernizr.touch===true){fn()}else{this.timeoutShowing=setTimeout(fn,this.options.showDelay)}},_hideTooltipNoDelay:function(){if(this.options.style==="tooltip"){if(this._canFadeOut===true){this._canFadeOut=false;this.tooltip.fadeOut(this.options.fadeTimespan,$.proxy(this._fadeOutEnd,this))}}else if(this.options.style==="popover"){this.tooltip.igPopover("hide")}this.visible=false},_showTooltipNoDelay:function(value){var tooltip;if(this._currentlyDisplayed===null){return}clearTimeout(this.timeoutHiding);tooltip=$("#"+this.id());if(this.options.style==="tooltip"){this._updateTooltip(value);if(this._canFadeIn===true){this._canFadeIn=false;tooltip.fadeIn(this.options.fadeTimespan,$.proxy(this._fadeInEnd,this))}}else if(this.options.style==="popover"){tooltip.igPopover("show",$(this._currentlyDisplayed),value)}this.visible=true},_fadeOutEnd:function(){this._canFadeOut=true},_fadeInEnd:function(){this._canFadeIn=true},_updateTooltip:function(value){var tooltipContainer=$("#"+this.id()+"_container");tooltipContainer.text(value);tooltipContainer.parent().css("max-width",$(this._currentlyDisplayed).width());this._positionTooltip(tooltipContainer.parent())},_positionTooltip:function(tooltip){var win=$(window),left,top,tfullw=tooltip.outerWidth(),tfullh=tooltip.outerHeight();left=this.mouseX-win.scrollLeft()+this.options.cursorLeftOffset;top=this.mouseY-win.scrollTop()+this.options.cursorTopOffset;if(left+tfullw>win.width()){left=win.width()-tfullw}if(top+tfullh>win.height()){top=win.height()-tfullh}tooltip.css({top:top+win.scrollTop(),left:left+win.scrollLeft()})},_columnFixed:function(args){var $tbodyFixed;if(this.grid.hasFixedColumns()){$tbodyFixed=this.grid.fixedTable().find("tbody");this._registerMouseEvents($tbodyFixed)}},_createHandlers:function(){this._dataRenderedHandler=$.proxy(this._dataRendered,this);this._rowsRenderedHandler=$.proxy(this._rowsRendered,this);this._rowsRenderingHandler=$.proxy(this._rowsRendering,this);this._gridMouseLeaveHandler=$.proxy(this._gridMouseLeave,this);this._gridMouseMoveHandler=$.proxy(this._gridMouseMove,this)},_registerGridEvents:function(){this.grid.element.bind("iggrid_rowsrendering.tooltip",this._rowsRenderingHandler);this.grid.element.bind("iggridrendered.tooltip",this._dataRenderedHandler);this.grid.element.bind("iggridrowsrendered.tooltip",this._rowsRenderedHandler)},_unregisterGridEvents:function(){this.grid.element.unbind("iggrid_rowsrendering.tooltip",this._rowsRenderingHandler);this.grid.element.unbind("iggridrendered.tooltip",this._dataRenderedHandler);this.grid.element.unbind("iggridrowsrendered.tooltip",this._rowsRenderedHandler)}});$.extend($.ui.igGridTooltips,{version:"13.1.20131.2523"})})(jQuery);