﻿/*!@license
* Infragistics.Web.ClientUI Video Player localization resources 13.1.20131.2523
*
* Copyright (c) 2011-2014 Infragistics Inc.
*
* http://www.infragistics.com/
*
*/
(function($){$.ig=$.ig||{};if(!$.ig.VideoPlayer){$.ig.VideoPlayer={};$.extend($.ig.VideoPlayer,{locale:{liveStream:"Live video",live:"Live",paused:"Paused",playing:"Playing",play:"Play",volume:"Volume",unsupportedVideoSource:"The current video sources does not contain a format that is supported by your browser.",missingVideoSource:"No compatible video source.",progressLabelLongFormat:"$currentTime$ / $duration$",progressLabelShortFormat:"$currentTime$",enterFullscreen:"Go Fullscreen",exitFullscreen:"Exit Fullscreen",skipTo:"SKIP TO",unsupportedBrowser:"The current browser does not support HTML5 video. <br/>Try upgrading to any of the following versions:",currentBrowser:"Current browser: {0}",ie9:"Microsoft Internet Explorer V 9+",chrome8:"Google Chrome V 8+",firefox36:"Mozilla Firefox V 3.6+",safari5:"Apple Safari V 5+",opera11:"Opera V 11+",ieDownload:"http://www.microsoft.com/windows/internet-explorer/default.aspx",operaDownload:"http://www.opera.com/download/",chromeDownload:"http://www.google.com/chrome",firefoxDownload:"http://www.mozilla.com/",safariDownload:"http://www.apple.com/safari/download/",buffering:"Buffering...",adMessage:"Ad: Video will resume in $duration$ seconds.",adMessageLong:"Ad: Video will resume in $duration$.",adMessageNoDuration:"Ad: Video will resume after the commercial.",adNewWindowTip:"Ad: Click to open ad content in a new window.",nonDivException:"The Infragistics HTML5 Video Player can be instantiated only on a DIV tag.",relatedVideos:"RELATED VIDEOS",replayButton:"Replay",replayTooltip:"Click to replay last video."}})}})(jQuery);/*!@license
 * Infragistics.Web.ClientUI jQuery HTML5 Video Player 13.1.20131.2523
 *
 * Copyright (c) 2011-2014 Infragistics Inc.
 *
 * http://www.infragistics.com/
 *
 * Depends on:
 *  jquery-1.4.2.js
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	modernizr.js
 *  infragistics.util.js
 *  infragistics.ui.shared.js
 */
if(typeof jQuery!=="function"){throw new Error("jQuery is undefined")}(function($){$.widget("ui.igVideoPlayer",{_const:{VOLUME_MAX:1,VOLUME_MIN:0,VIDEO_STATE_TIMEOUT:200,SCROLL_TIMEOUT:100,COMMERCIAL_SEEK_DELTA:2,SLIDE_SEEK_TIMEOUT:500,HREF:"#"},_id:function(id){return this.element[0].id+id},options:{sources:[],width:null,height:null,posterUrl:"",preload:false,autoplay:false,autohide:true,volumeAutohideDelay:1e3,centerButtonHideDelay:1200,loop:false,browserControls:false,fullscreen:false,volume:.5,muted:false,title:"",showSeekTime:true,progressLabelFormat:"${currentTime} / ${duration}",bookmarks:[{time:0,title:"",disabled:false}],relatedVideos:[{imageUrl:"",title:"",width:null,height:null,link:"",sources:[],css:null}],banners:[{imageUrl:"",times:[],closeBanner:true,animate:true,visible:true,duration:1e3,autohide:false,hidedelay:1e4,link:null,width:null,height:null,css:null}],commercials:{linkedCommercials:[{sources:[],startTime:10,link:"",title:""}],embeddedCommercials:[{startTime:20,endTime:30,link:"",title:""}],alwaysPlayCommercials:false,showBookmarks:true,adMessage:{animate:true,autoHide:true,hideDelay:2e4,animationDuration:1e3}}},events:{ended:"ended",playing:"playing",paused:"paused",buffering:"buffering",progress:"progress",waiting:"waiting",bookmarkHit:"bookmarkHit",bookmarkClick:"bookmarkClick",enterFullScreen:"enterFullScreen",exitFullScreen:"exitFullScreen",relatedVideoClick:"relatedVideoClick",bannerVisible:"bannerVisible",bannerHidden:"bannerHidden",bannerClick:"bannerClick",browserNotSupported:"browserNotSupported"},css:{baseClasses:"ui-widget ui-igplayer",controlsClass:"ui-widget-header ui-igplayer-controls ui-igplayer-grid ui-igplayer-autohide ui-corner-all",controlsHideClass:"ui-igplayer-controls-hide",videoClass:"ui-igplayer-video",unsupportedBrowserClass:"ui-html5-non-html5-supported-message ui-helper-clearfix",activeVideoClass:"ui-igplayer-active-video",playButtonClass:"ui-igplayer-playbutton",progressBarClass:"ui-igplayer-progressbar ui-corner-all",fullScreenClass:"ui-igplayer-fullscreen-button",fullScreenIconClass:"ui-icon ui-igbutton-icon ui-icon-arrow-4-diag",volumeControlClass:"ui-igplayer-volumecontrol",volumeSliderClass:"ui-igplayer-volumeslider",progressLabelClass:"ui-igplayer-progresslabel",bookmarkContainerClass:"ui-widget ui-igplayer-bookmark-container",bookmarkContainerHeaderClass:"ui-widget-header ui-igplayer-bookmark-header",bookmarkListClass:"ui-widget-content ui-igplayer-bookmark-list",bookmarkItemDisabledClass:"ui-igplayer-bookmark-item-disabled",bookmarkItemTimeClass:"ui-igplayer-bookmark-item-time",bookmarkItemTitleClass:"ui-igplayer-bookmark-item-title",bookmarkActiveItemClass:"ui-igplayer-bookmark-active-item",relatedVideosContainerClass:"ui-igplayer-related-video-container",relatedVideosOuterContainerClass:"ui-igplayer-related-video-outer-container",relatedVideoClass:"ui-igplayer-related-video",relatedVideoFirstClass:"ui-igplayer-related-video-first",relatedVideoLastClass:"ui-igplayer-related-video-last",relatedVideoHoverClass:"ui-igplayer-related-video-hover",relatedVideoScrollLeftClass:"ui-igplayer-related-scroller-left",relatedVideoScrollLeftIconClass:"ui-icon-triangle-1-w",relatedVideoScrollRightClass:"ui-igplayer-related-scroller-right",relatedVideoScrollRightIconClass:"ui-icon-triangle-1-e",relatedVideoScrollListClass:"ui-igplayer-related-list",relatedVideosHeaderClass:"ui-igplayer-related-video-header",relatedVideoBarClass:"ui-igplayer-related-video-bar",relatedVideoReplayClass:"ui-igplayer-related-video-replay",relatedVideoReplayIconClass:"ui-icon-arrowrefresh-1-s",bannerContainerClass:"ui-igplayer-banner-container",bannerClass:"ui-igplayer-banner ui-corner-all",bannerCloseClass:"ui-igplayer-banner-close",bannerCloseIconClass:"ui-icon-close",adMsgContainerClass:"ui-igplayer-ad-msg-container",adMsgClass:"ui-igplayer-ad-msg",adMsgCloseClass:"ui-igplayer-ad-msg-close",adMsgCloseIconClass:"ui-icon-close",linkedBookmarkClass:"ui-igplayer-linked-bookmark",adBookmarkClass:"ui-igplayer-ad-bookmark",unsupportedVideoSourceClass:"ui-igplayer-not-supported-video-source",unsupportedVideoSourceIconClass:"ui-igplayer-not-supported-video-source-icon",centerPlayButtonClass:"ui-igplayer-centerplaybutton-play",centerPauseButtonClass:"ui-igplayer-centerplaybutton-pause",centerPlayButtonIconClass:"ui-igplayer-centerplaybutton-icon",waitingIndicatorClass:"ui-igplayer-waiting",waitingIndicatorIconClass:"ui-igplayer-waiting-icon",seekTooltipClass:"ui-igplayer-seektooltip"},widget:function(){return this.element},_createWidget:function(){var o=this.options;o.bookmarks=[];o.relatedVideos=[];o.banners=[];o.commercials.linkedCommercials=[];o.commercials.embeddedCommercials=[];$.Widget.prototype._createWidget.apply(this,arguments)},_create:function(){this.supportsVideo=this.supports_video();if(typeof Modernizr==="object"&&Modernizr.touch){this.options.browserControls=true}if(this.element.is("div")){this.container=this.element}else if(this.element.is("video")){this.container=$("<div></div>").attr("id",this._id("_container")).insertBefore(this.element);this.element.appendTo(this.container)}else{throw new Error($.ig.VideoPlayer.locale.nonDivException)}this._oldWidth=this.element.css("width");this._oldHeight=this.element.css("height");this._renderControl()},_renderControl:function(){var o=this.options,video,css=this.css;this._prevReadyState=0;this._bookmarksRendered=false;if(this.supportsVideo){this._renderBanners()}this.currentVideo=video=this._createMainVideoElement().addClass(css.videoClass);if(o.disabled){this.container.addClass("ui-state-disabled")}if(o.width){video.css("width",o.width);this.container.css("width",o.width)}if(o.height){video.css("height",o.height);this.container.css("height",o.height)}if(this.supportsVideo){this._baseZIndex=parseInt(this.container.css("z-index"),10)||0;this._attachEvents(video);this._renderSources(o.sources,video);this._analyzeSource(video);setTimeout($.proxy(this._onVideoStateChange,this),this._const.VIDEO_STATE_TIMEOUT);this._createBigPlayButton();this._createWaitingIndicator();this._renderEmbeddedCommercials();this._renderCommercials();video[0].muted=o.muted;if(o.muted&&$.ig.util.isWebKit){video[0].volume=0}else if(o.volume>=this._const.VOLUME_MIN&&o.volume<=this._const.VOLUME_MAX){video[0].volume=o.volume}if(!o.browserControls){this._renderControls()}this._lastPausedState=video[0].paused;if(o.fullscreen){this._setOption("fullscreen",true,true)}this._renderRelatedVideos()}else{this.currentVideo.hide();$.ig.util._renderUnsupportedBrowser(this,$.ig.VideoPlayer.locale)}$("#"+this._id("_detectError")).appendTo(this.container).bind({click:function(event){event.preventDefault()}});this.container.addClass(css.baseClasses)},_createVideoElement:function(id){var video=$("<video></video>").attr("id",id);return video},_saveExistingVideoProperties:function(video){this._oldAutoPlay=video.attr("autoplay");this._oldPreload=video.attr("preload");this._oldLoop=video.attr("loop");this._oldPoster=video.attr("poster");this._oldControls=video.attr("controls");this._oldSrc=video.attr("src");this._oldMuted=video[0].muted;this._oldVolume=video[0].volume;video.removeAttr("autoplay");video.removeAttr("preload");video.removeAttr("loop");video.removeAttr("poster");video.removeAttr("controls");video.removeAttr("src")},_restoreExistingVideoProperties:function(video){video.attr("autoplay",this._oldAutoPlay);video.attr("preload",this._oldPreload);video.attr("loop",this._oldLoop);video.attr("poster",this._oldPoster);video.attr("controls",this._oldControls);video.attr("src",this._oldSrc);video[0].muted=this._oldMuted;video[0].volume=this._oldVolume},_createMainVideoElement:function(){var o=this.options,isVideoExisting=this.element.is("video"),video=isVideoExisting?this.element:this._createVideoElement(this._id("_video"));if(isVideoExisting){this._saveExistingVideoProperties(video)}if(o.autoplay){video.attr("autoplay",true)}video.attr("preload","metadata");if(o.preload){video.attr("preload","auto")}if(o.browserControls){video.attr("controls",true)}if(o.loop){video.attr("loop",true)}if(o.posterUrl.length>0){video.attr("poster",o.posterUrl)}return video.appendTo(this.container)},_renderUnsupportedBrowser:function(){if(this._trigger(this.events.browserNotSupported)){var container=$("<div></div>").addClass(this.css.unsupportedBrowserClass).appendTo(this.container),ul,browserUnsupported;if($.ig.util.isIE){browserUnsupported="Internet Explorer "+$.ig.util.browserVersion}else if($.ig.util.isOpera){browserUnsupported="Opera "+$.ig.util.browserVersion}else if($.ig.util.isWebKit){browserUnsupported="Webkit "+$.ig.util.browserVersion}else if($.ig.util.isFF){browserUnsupported="Mozilla Firefox "+$.ig.util.browserVersion}else{browserUnsupported=$.ig.util.browserVersion}$("<div></div>").addClass("ui-igvideoplayer-current-browser-label").html($.ig.VideoPlayer.locale.currentBrowser.replace("{0}",browserUnsupported)).appendTo(container);$("<div></div>").addClass("ui-igvideoplayer-non-html5-text").html($.ig.VideoPlayer.locale.unsupportedBrowser).appendTo(container);ul=$("<ul></ul>").addClass("ui-igplayer-browsers-list").appendTo(container);$("<a></a>").attr("href",$.ig.VideoPlayer.locale.chromeDownload).attr("target","_blank").addClass("ui-igplayer-chrome-icon").html($.ig.VideoPlayer.locale.chrome8).appendTo($("<li></li>").addClass("ui-corner-all").appendTo(ul));$("<a></a>").attr("href",$.ig.VideoPlayer.locale.firefoxDownload).attr("target","_blank").addClass("ui-igplayer-firefox-icon").html($.ig.VideoPlayer.locale.firefox36).appendTo($("<li></li>").addClass("ui-corner-all").appendTo(ul));$("<a></a>").attr("href",$.ig.VideoPlayer.locale.operaDownload).attr("target","_blank").addClass("ui-igplayer-Opera-icon").html($.ig.VideoPlayer.locale.opera11).appendTo($("<li></li>").addClass("ui-corner-all").appendTo(ul));$("<a></a>").attr("href",$.ig.VideoPlayer.locale.safariDownload).attr("target","_blank").addClass("ui-igplayer-safari-icon").html($.ig.VideoPlayer.locale.safari5).appendTo($("<li></li>").addClass("ui-corner-all").appendTo(ul));$("<a></a>").attr("href",$.ig.VideoPlayer.locale.ieDownload).attr("target","_blank").addClass("ui-igplayer-ie-icon").html($.ig.VideoPlayer.locale.ie9).appendTo($("<li></li>").addClass("ui-corner-all").appendTo(ul));this.container.addClass("ui-igvideoplayer-non-html5")}},_renderRelatedVideoBar:function(container){var css=this.css,control=this,relatedVideoBar=$("<div></div>").attr("id",this._id("_rv_bar")).addClass(css.relatedVideoBarClass).appendTo(container);$("<a></a>").attr("id",this._id("_rv_bar_fs")).appendTo($("<div></div>").css({position:"absolute",top:0,left:0,"text-align":"right",width:"100%",height:"100%"}).appendTo(relatedVideoBar)).igButton({link:{href:this._const.HREF},css:{buttonLabelClass:css.fullScreenIconClass}}).attr("title",$.ig.VideoPlayer.locale.enterFullscreen).addClass(css.fullScreenClass).bind({click:function(event){event.preventDefault();control._setOption("fullscreen",!control.options.fullscreen)}});$("<a></a>").attr("id",this._id("_rv_bar_replay")).appendTo(relatedVideoBar).igButton({onlyIcons:false,labelText:$.ig.VideoPlayer.locale.replayButton,icons:{primary:css.relatedVideoReplayIconClass},link:{href:this._const.HREF}}).attr("title",$.ig.VideoPlayer.locale.replayTooltip).bind({click:function(event){event.preventDefault();if(!$(this).igButton("option","disabled")){control.togglePlay()}}}).addClass(css.relatedVideoReplayClass)},_renderScrollButtons:function(container){var css=this.css,ul;$("<a></a>").attr("id",this._id("_rv_left")).appendTo(container).igButton({onlyIcons:true,icons:{primary:css.relatedVideoScrollLeftIconClass},link:{href:this._const.HREF}}).addClass(css.relatedVideoScrollLeftClass).css("position","absolute").hide();ul=$("<ul></ul>").addClass(css.relatedVideoScrollListClass).appendTo(container);$("<a></a>").attr("id",this._id("_rv_right")).appendTo(container).igButton({onlyIcons:true,icons:{primary:css.relatedVideoScrollRightIconClass},link:{href:this._const.HREF}}).addClass(css.relatedVideoScrollRightClass).css("position","absolute");return ul},_renderRelatedVideos:function(){var o=this.options,related=o.relatedVideos||[],len=related.length,i=0,css=this.css,container,scrollContainer,ulContainer,ulContainerWidth=10,currentVideo,control=this;if(len>0){container=$("<div></div>").attr("id",this._id("_rvcc")).addClass(css.relatedVideosOuterContainerClass).appendTo(this.container).hide();$("<div><div>").html($.ig.VideoPlayer.locale.relatedVideos).addClass(css.relatedVideosHeaderClass).appendTo(container);scrollContainer=$("<div></div>").attr("id",this._id("_rvc")).appendTo(container).addClass(css.relatedVideosContainerClass);ulContainer=this._renderScrollButtons(scrollContainer);this._renderRelatedVideoBar(container);this._rvUlWidth=0;this._rvImagesToLoad=0;this._rvImagesLoaded=0;for(i;i<len;i++){if(related[i].imageUrl&&related[i].imageUrl!==""){currentVideo=this._renderRelatedVideo(related[i],ulContainer,i===0,i===len-1);this._rvImagesToLoad++;ulContainerWidth+=currentVideo.outerWidth(true)}}if(ulContainerWidth>container.width()&&ulContainerWidth>ulContainer.width()){ulContainer.width(ulContainerWidth)}this.relatedScrollers=$("a",scrollContainer).bind({mouseover:function(){if(!control._isScrolling){control._isScrolling=true;control._leftDirection=$(this).hasClass(control.css.relatedVideoScrollLeftClass);control._rvDoScroll()}},mouseout:function(){control._rvStopScroll()}});this.relatedVideoElements=$("."+this.css.relatedVideoClass.split(" ")[0],ulContainer).each(function(i){$(this).data("related-index",i)}).bind({mouseover:function(){$(this).addClass(control.css.relatedVideoHoverClass).children().filter("div").show()},mouseout:function(){$(this).removeClass(control.css.relatedVideoHoverClass).children().filter("div").hide()},click:function(event){var relatedVideo=control.options.relatedVideos[$(this).data("related-index")];if(control._relatedVideoClick(relatedVideo,$(this),event)){if(relatedVideo.link&&relatedVideo.link.length>0){window.open(relatedVideo.link,"_blank")}else if(relatedVideo.sources){control._renderSources(relatedVideo.sources,control.currentVideo);control._analyzeSource(control.currentVideo,true);control.play()}}}})}},_rvScrollOnce:function(){var container=$("#"+this._id("_rvc")),ul=$("ul",container),currentLeftStr=ul[0].style.left,currentLeft=parseInt(currentLeftStr===""||currentLeftStr==="auto"?"0px":currentLeftStr,10),pixelsToScroll=10,newLeft=this._leftDirection?currentLeft+pixelsToScroll:currentLeft-pixelsToScroll,left=$("#"+this._id("_rv_left")),right=$("#"+this._id("_rv_right")),ulWidth=ul.width(),scrollContainerWidth=container.width(),continueScrolling=true;ul[0].style.left=newLeft+"px";if(currentLeft===0&&newLeft<0){left.show()}if(newLeft>=0&&currentLeft!==0&&left[0].style.display!=="none"){left.hide();continueScrolling=false}if(scrollContainerWidth-newLeft>=ulWidth&&right[0].style.display!=="none"){continueScrolling=false;right.hide()}else if(right[0].style.display==="none"){right.show()}return continueScrolling},_rvDoScroll:function(){var continueScrolling=this._isScrolling&&this._rvScrollOnce();if(continueScrolling){this._scrollingTimoutId=setTimeout($.proxy(this._rvDoScroll,this),this._const.SCROLL_TIMEOUT)}else{this._rvStopScroll()}},_rvStopScroll:function(){if(this._isScrolling){clearTimeout(this._scrollingTimoutId);this._isScrolling=false}},_relatedVideoClick:function(relatedVideo,relatedElement,event){var args={relatedVideo:relatedVideo,relatedVideoElement:relatedElement};return this._trigger(this.events.relatedVideoClick,event,args)},_renderRelatedVideo:function(related,container,isFirst,isLast){var rv=$("<li></li>").appendTo(container).addClass(this.css.relatedVideoClass),relatedImg=$("<img/>").appendTo(rv),self=this;if(isFirst||isLast){rv.addClass(isFirst?this.css.relatedVideoFirstClass:this.css.relatedVideoLastClass)}if(related.imageUrl&&related.imageUrl!==""){relatedImg.attr("src",related.imageUrl)}if(related.title&&related.title!==""){relatedImg.attr("title",related.title)}if(related.css&&related.css!==""){relatedImg.addClass(related.css)}if(related.width&&related.width!==""){relatedImg.css("width",related.width)}if(related.height&&related.height!==""){relatedImg.css("height",related.height)}$("<div></div>").appendTo(relatedImg.parent()).css("position","absolute").hide();relatedImg.bind({load:function(){self._imageLoaded(this)},error:function(){self._rvImagesLoaded++;self._onImagesLoaded()},readystatechange:function(){self._imageLoaded(this)}});return rv},_imageLoaded:function(img){var rs=img.readyState,width=parseInt(img.style.width,10),height=parseInt(img.style.height,10),spanSize;if(!rs||new RegExp("loaded|complete").test(rs)){this._rvUlWidth+=width+parseInt($(img).parent().css("marginRight"),10)+parseInt($(img).parent().css("marginLeft"),10);this._rvImagesLoaded++;if(width>24&&height>24){if(width>50&&height>50){spanSize=48}else if(width>34&&height>34){spanSize=32}else{spanSize=24}$(img).parent().children().filter("div").addClass("ui-igplayer-related-video-hover-x"+spanSize).css({width:spanSize,height:spanSize,top:height/2-spanSize/2,left:width/2-spanSize/2})}}this._onImagesLoaded()},_onImagesLoaded:function(){if(this._rvImagesLoaded===this._rvImagesToLoad){var container=$("#"+this._id("_rvc"));$("ul",container).css("width",this._rvUlWidth+4);container.parent().show();if(this._rvUlWidth<container.width()){this.relatedScrollers.hide()}else{$(this.relatedScrollers[1]).show()}container.parent().hide();delete this._rvUlWidth;delete this._rvImagesLoaded;delete this._rvImagesToLoad}},_renderEmbeddedCommercials:function(){var ec=this.options.commercials.embeddedCommercials||[],i=0,len=ec.length,filtered=[],val;for(i;i<len;i++){val=ec[i];if(val&&val.startTime&&val.endTime&&val.startTime<val.endTime){filtered.push(val)}}ec=filtered;len=ec.length;if(ec&&len>0){this._embeddedCommercialsShow=$.extend(true,[],ec);this._embeddedCommercialIndex=0;this._renderAdMessage()}},_renderCommercials:function(){var o=this.options,com=o.commercials.linkedCommercials||[],control=this;if(com.length>0){this._createVideoElement(this._id("_com_video")).attr("preload","auto").appendTo(this.container).addClass(this.css.videoClass).bind({ended:function(){var slider=$("#"+control._id("_ctrls_s")),bookmarks=slider.data("igSlider").bookmarks;control._hideWaitingIndicator();control._commercialIndex++;control._commercialsShow.shift();control._commercialPlaying=false;control.currentVideo=control._getMainVideo();control.currentVideo.show();$(this).hide();slider.igSlider("option","disabled",false);if(bookmarks){bookmarks.show()}control.currentVideo[0].muted=this.muted;control.currentVideo[0].play();control.currentVideo.addClass(control.css.videoClass);control.controls[control._activeControlsIndex].css("z-index","");$("#"+control._id("_seek_tooltip")).css("z-index","");$("#"+control._id("_play")).css("z-index","")},waiting:function(event){control._onVideoWaiting(event);control._waiting(this.currentSrc,this.currentTime,this.duration,event)},timeupdate:function(event){control._changeCurrentTime(event)},playing:function(event){control._hideWaitingIndicator();$("span",$("#"+control._id("_ctrls_play"))).addClass("ui-icon-pause").removeClass("ui-icon-play");control._playing(this.currentSrc,this.duration,event)},pause:function(event){$("span",$("#"+control._id("_ctrls_play"))).addClass("ui-icon-play").removeClass("ui-icon-pause");control._paused(this.currentSrc,this.duration,event)},click:function(event){event.preventDefault();var link=control.options.commercials.linkedCommercials[control._commercialIndex].link;if(link&&link.length>0){window.open(link,"_blank")}}}).hide();this._buildCommercialsShow();this._renderAdMessage()}},_renderAdClose:function(container){var control=this;$("<a></a>").attr("id",this._id("_ad_msg_close")).appendTo(container).igButton({onlyIcons:true,icons:{primary:this.css.adMsgCloseIconClass},link:{href:this._const.HREF}}).addClass(this.css.adMsgCloseClass).bind("click",function(event){event.preventDefault();event.stopPropagation();control.hideAdMessage()})},_renderAdMessage:function(){if($("#"+this._id("_ad_msg_c")).length===0){var css=this.css,container;container=$("<div></div>").attr("id",this._id("_ad_msg_c")).addClass(css.adMsgContainerClass).prependTo(this.container).bind({mouseover:function(){$(this).addClass("ui-state-hover")},mouseout:function(){$(this).removeClass("ui-state-hover")}}).hide();$("<span></span>").attr("id",this._id("_ad_msg")).appendTo(container).addClass(css.adMsgClass).html($.ig.VideoPlayer.locale.adMessage);this._renderAdClose(container)}},_showAdMessage:function(seconds){var adMsgContainer=$("#"+this._id("_ad_msg_c")),msgOpt=this.options.commercials.adMessage;this._updateAdMessage(seconds,true);adMsgContainer.css("width",this.container.css("width"));if(msgOpt.animate){adMsgContainer.slideToggle(msgOpt.animationDuration)}else{adMsgContainer.show()}if(msgOpt.autoHide){this._adHideTimeout=setTimeout($.proxy(this.hideAdMessage,this),msgOpt.hideDelay)}},_updateAdMessage:function(seconds,force){var msg=$("#"+this._id("_ad_msg"));if(msg.is(":visible")||force){if(isNaN(seconds)){msg.html($.ig.VideoPlayer.locale.adMessageNoDuration)}else{seconds=parseInt(seconds,10);if(seconds>60){msg.html($.ig.VideoPlayer.locale.adMessageLong.replace("$duration$",this._toTimeString(seconds)))}else{msg.html($.ig.VideoPlayer.locale.adMessage.replace("$duration$",seconds))}}this._isHiddenAdMessage=false}else if(!this._isHiddenAdMessage){this._showAdMessage(seconds)}},hideAdMessage:function(){clearTimeout(this._adHideTimeout);var msg=$("#"+this._id("_ad_msg_c")),msgOpt=this.options.commercials.adMessage;if(msg.is(":visible")){if(msgOpt.animate){msg.slideToggle(msgOpt.animationDuration)}else{msg.hide()}this._isHiddenAdMessage=true}},_buildCommercialsShow:function(){var com=this.options.commercials.linkedCommercials||[],len=com.length,i=0;this._commercialsShow=[];this._commercialIndex=0;for(i;i<len;i++){this._commercialsShow.push(com[i].startTime)}this._commercialsShow=$.extend(true,[],this._commercialsShow)},playCommercial:function(commercial){if(!commercial||!commercial.sources){return}var comVideo=$("#"+this._id("_com_video")),videoOffset=this.currentVideo.offset(),slider=$("#"+this._id("_ctrls_s")),bookmarks=slider.data("igSlider").bookmarks,bookmarkTitle=$("#"+this._id("_ctrls_s_tooltip"));this._commercialPlaying=true;$("source",comVideo).remove();this._renderSources(commercial.sources,comVideo);this._analyzeSource(comVideo);this.currentVideo[0].pause();this.currentVideo.removeClass(this.css.videoClass);this.controls[this._activeControlsIndex].css("z-index",this._baseZIndex+5e3);$("#"+this._id("_seek_tooltip")).css("z-index",this._baseZIndex+5e3);$("#"+this._id("_play")).css("z-index",this._baseZIndex+5e3);slider.igSlider("option","disabled",true);if(bookmarks&&bookmarkTitle){bookmarks.hide();bookmarkTitle.hide()}comVideo[0].muted=this.currentVideo[0].muted;comVideo[0].play();if(commercial.link&&commercial.link.length>0){comVideo.attr("title",$.ig.VideoPlayer.locale.adNewWindowTip)}else{comVideo.removeAttr("title")}comVideo.css("top",videoOffset.top).css("left",videoOffset.left).css("width",this.currentVideo.css("width")).css("height",this.currentVideo.css("height")).show();this.currentVideo.hide();this.currentVideo=comVideo},_renderBanners:function(){var banners=this.options.banners||[],len=banners.length,i=0,parent=$("<div></div>").appendTo(this.container).addClass(this.css.bannerContainerClass),banner;this._bannerShow=[];for(i;i<len;i++){banner=banners[i];if(banner.imageUrl&&banner.imageUrl.length>0){this._renderBannerContainer(banner,this._id("_banner_grid"+i),parent).data("banner-index",i)}this._bannerShow.push($.extend(true,[],banner.times))}},_buildBannersShow:function(){var banners=this.options.banners||[],len=banners.length,i=0;if(len>0){this._bannerShow=[]}for(i;i<len;i++){this._bannerShow.push($.extend(true,[],banners[i].times))}},_renderBannerClose:function(container,id){var css=this.css,control=this;$("<a></a>").attr("id",id+"_banner_close").appendTo($("<div></div>").css({position:"absolute",top:0,left:0,"text-align":"right",width:"100%",height:"100%"}).appendTo(container)).addClass(css.bannerCloseClass).igButton({onlyIcons:true,icons:{primary:css.bannerCloseIconClass},link:{href:this._const.HREF}}).bind("click",function(event){event.preventDefault();event.stopPropagation();control.hideBanner($(this).parent().parent().data("banner-index"))})},_renderBannerContainer:function(banner,id,parent){var css=this.css,control=this,container=$("<div></div>").attr("id",id).appendTo(parent),img=$("<img></img>").attr("id",id+"_img").attr("src",banner.imageUrl).appendTo(container);this.banner=container.addClass(css.bannerClass);if(!banner.visible){container.hide()}if(banner.closeBanner){this._renderBannerClose(container,id)}if(banner.width){container.css("width",banner.width);img.attr("width",parseInt(banner.width,10))}if(banner.height){container.css("height",banner.height);img.attr("height",parseInt(banner.height,10))}if(banner.css){container.addClass(banner.css)}container.bind("click",function(event){var noCancel=true,args={bannerElement:$(event.currentTarget)};noCancel=control._trigger(control.events.bannerClick,event,args);if(banner.link&&banner.link.length>0&&noCancel){window.open(banner.link,"_blank")}});return container},showBanner:function(index){if(this.options.banners&&index>=0&&index<this.options.banners.length){var banner=this.options.banners[index],id=this._id("_banner_grid"+index),container=$("#"+id);if(banner.animate){container.fadeIn(banner.duration)}else{container.show()}this._bannerVisible(index,container);if(banner.autohide){this._bannerHideTimeout=setTimeout(this._createDelegate(this,this.hideBanner,[index]),banner.hidedelay)}}},_createDelegate:function(instance,method,args){return function(){return method.apply(instance,args)}},hideBanner:function(index){if(this.options.banners&&index>=0&&index<this.options.banners.length){clearTimeout(this._bannerHideTimeout);var banner=this.options.banners[index],container=$("#"+this._id("_banner_grid"+index));if(banner.animate){container.fadeOut(banner.duration)}else{container.hide()}this._bannerHidden(index,container)}},_renderSources:function(sources,video){var control=this;$(sources).each(function(){control._renderSource(this,video)})},_renderSource:function(source,video){var qmIndex=source.indexOf("?"),extStartIndex=source.lastIndexOf(".")+1,extEndIndex=qmIndex>-1?qmIndex:source.length,extension=source.substring(extStartIndex,extEndIndex);$("<source></source>").attr("src",source).attr("type",("video/"+source.substring(source.lastIndexOf(".")+1,source.length)).replace("/ogv","/ogg")).appendTo(video);video.data(extension,source)},_getMainVideo:function(){return this.element.is("video")?this.element:$("#"+this._id("_video"))},_setOption:function(key,value,force){var video=this.currentVideo,videoElem=video[0],mainVideo=this._getMainVideo(),videoOffset=video.offset(),options=this.options,noCancel=true,fsVideoH=0;if(this.options[key]===value){return}switch(key){case"disabled":if(value){this.container.addClass("ui-state-disabled")}else{this.container.removeClass("ui-state-disabled")}break;case"sources":$("source",mainVideo).remove();this._renderSources(value,mainVideo);this._analyzeSource(mainVideo);break;case"width":if(value!==options.width){video.css("width",value);this.container.css("width",value);if(!options.browserControls){$("#"+this._id("_ctrls")).parent().css("width",value);$("#"+this._id("_title_ctrls")).parent().css("width",value)}options.width=value}break;case"height":if(value!==options.height){video.css("height",value);this.container.css("height",value);options.height=value}break;case"posterUrl":if(value!==options.posterUrl){video.attr("poster",value);options.posterUrl=value}break;case"loop":if(value!==options.loop){videoElem.loop=value;options.loop=value}break;case"browserControls":if(typeof Modernizr==="object"&&Modernizr.touch){return}if(value!==options.browserControls){if(!value){videoElem.controls=false;this._ensureVolume();this._renderControls();this._detectBuffered()}else{videoElem.controls=true;this._destroyControls()}options.browserControls=value}break;case"autohide":if(!options.browserControls){if(value){this._onControlMouseOut()}else{this._onControlMouseOver()}}options.autohide=value;break;case"fullscreen":if(value!==options.fullscreen||force){if(value){noCancel=this._enterFullScreen(videoElem.currentSrc);if(noCancel){this.container.data("style.position",this.container.css("position"));this.container.data("document.scrollTop",$(document).scrollTop());this.container.data("document.scrollLeft",$(document).scrollLeft());this.container.data("style.left",this.container.css("left"));this.container.data("style.top",this.container.css("top"));this.container.css("z-index",this._baseZIndex+1e4);$(document).scrollTop(0);$(document).scrollLeft(0);this.container.css("position","fixed").css("height","100%").css("width","100%").css("left","0px").css("top","0px");$("#"+this._id("_ctrls")).parent().css("width","100%");if(this._commercialPlaying){video.css("top",0).css("left",0);mainVideo.css("height","100%").css("width","100%")}video.css("height","100%").css("width","100%");if(!options.browserControls){$("span",$("#"+this._id("_ctrls_fs_btn"))).removeClass("ui-icon-arrow-4-diag").addClass("ui-icon-closethick")}if($("#"+this._id("_rv_bar_fs")).is(":visible")){$("span",$("#"+this._id("_rv_bar_fs"))).removeClass("ui-icon-arrow-4-diag").addClass("ui-icon-closethick")}if(options.bookmarks&&options.bookmarks.length>0){$("#"+this._id("_bookmarks")).hide()}}}else{noCancel=this._exitFullScreen(videoElem.currentSrc);if(noCancel){this.container.css("position",this.container.data("style.position")).css("left",this.container.data("style.left")).css("top",this.container.data("style.top"));this.container.css("z-index",this._baseZIndex);$(document).scrollTop(this.container.data("document.scrollTop"));$(document).scrollLeft(this.container.data("document.scrollLeft"));if(options.height){if(options.bookmarks&&options.bookmarks.length>0){fsVideoH=parseInt(options.height,10)-parseInt($("#"+this._id("_bookmarks")).css("height"),10);if(this._commercialPlaying){mainVideo.css("height",fsVideoH)}video.css("height",fsVideoH)}else{if(this._commercialPlaying){mainVideo.css("height",options.height)}video.css("height",options.height)}this.container.css("height",options.height)}else{if(this._commercialPlaying){mainVideo.css("height","")}video.css("height","");this.container.css("height","")}if(options.width){if(this._commercialPlaying){mainVideo.css("width",options.width)}video.css("width",options.width);$("#"+this._id("_ctrls")).parent().css("width",options.width);this.container.css("width",options.width)}else{if(this._commercialPlaying){mainVideo.css("width","")}video.css("width","");$("#"+this._id("_ctrls")).parent().css("width","");this.container.css("width","")}if(this._commercialPlaying){video.css("top",videoOffset.top).css("left",videoOffset.left)}if(!options.browserControls){$("span",$("#"+this._id("_ctrls_fs_btn"))).removeClass("ui-icon-closethick").addClass("ui-icon-arrow-4-diag")}if($("#"+this._id("_rv_bar_fs")).is(":visible")){$("span",$("#"+this._id("_rv_bar_fs"))).removeClass("ui-icon-closethick").addClass("ui-icon-arrow-4-diag")}if(options.bookmarks&&options.bookmarks.length>0){$("#"+this._id("_bookmarks")).show()}}}if(!noCancel){return}if($("#"+this._id("_waiting")).is(":visible")){this._showWaitingIndicator()}if($("#"+this._id("_play")).is(":visible")){this._showCenterPlayButton()}if($("#"+this._id("_ad_msg_c")).is(":visible")){$("#"+this._id("_ad_msg_c")).css("width",this.container.css("width"))}if($("#"+this._id("_ctrls_vs")).is(":visible")){this._hideVolumeSlider()}if($("#"+this._id("_detectError")).is(":visible")){this._showUnsupportedVideoSourceMsg()}$("body").toggleClass("ui-igplayer-full-screen-mode");if(!options.browserControls){$("#"+this._id("_ctrls_fs_btn")).attr("title",value?$.ig.VideoPlayer.locale.exitFullscreen:$.ig.VideoPlayer.locale.enterFullscreen)
}if($("#"+this._id("_rv_bar_fs")).is(":visible")){$("#"+this._id("_rv_bar_fs")).attr("title",value?$.ig.VideoPlayer.locale.exitFullscreen:$.ig.VideoPlayer.locale.enterFullscreen)}options.fullscreen=value}break;case"volume":if(value!==options.volume&&value>=this._const.VOLUME_MIN&&value<=this._const.VOLUME_MAX){options.volume=videoElem.volume=value;if(value>0&&videoElem.muted){options.muted=videoElem.muted=false}else if(value===0&&!videoElem.muted){options.muted=videoElem.muted=true}if(!options.browserControls){this._adjustVolumeButton(value);$("#"+this._id("_ctrls_vs")).igSlider("option","value",value*100)}}break;case"muted":if(value!==options.muted){options.muted=videoElem.muted=value;$("#"+this._id("_ctrls_vs")).igSlider("option","value",value?0:(options.volume!==0?options.volume:.3)*100);if(options.volume===0){options.volume=.3}if(!value&&videoElem.volume===0){videoElem.volume=options.volume}if(!options.browserControls){this._adjustVolumeButton($("#"+this._id("_ctrls_vs")).igSlider("option","value"))}}break;case"title":$("#"+this._id("_title_ctrls_t")).html(value);break;case"progressLabelFormat":options.progressLabelFormat=value;this._updateProgressLabel();break;case"alwaysPlayCommercials":if(value!==options.commercials.alwaysPlayCommercials){options.commercials.alwaysPlayCommercials=value;if(value){this.resetCommercialsShow()}}break;case"bookmarks":this._destroyBookmarks();options.bookmarks=value;this._renderBookmarks();break;case"relatedVideos":this._destroyRelatedVideos();options.relatedVideos=value;this._renderRelatedVideos();break;default:break}$.Widget.prototype._setOption.apply(this,arguments)},_onVideoStateChange:function(){var video=this.currentVideo,videoElem=video[0],o=this.options,prevReadyState=this._prevReadyState,readyState=videoElem.readyState;if(prevReadyState>=videoElem.HAVE_FUTURE_DATA&&readyState<=videoElem.HAVE_CURRENT_DATA){if(!videoElem.ended){this._showWaitingIndicator()}}else if(prevReadyState<=videoElem.HAVE_CURRENT_DATA&&readyState===videoElem.HAVE_FUTURE_DATA){this._hideWaitingIndicator()}else if(readyState===videoElem.HAVE_ENOUGH_DATA){if(prevReadyState<=videoElem.HAVE_CURRENT_DATA){this._hideWaitingIndicator()}else{return}}this._prevReadyState=readyState;this._detectBuffered();if(this._lastPausedState!==videoElem.paused){if(this._lastPausedState){this._showCenterPlayButton().removeClass(this.css.centerPauseButtonClass).addClass(this.css.centerPlayButtonClass)}else{this._showCenterPlayButton().removeClass(this.css.centerPlayButtonClass).addClass(this.css.centerPauseButtonClass)}setTimeout($.proxy(this._hideCenterPlayButton,this),o.centerButtonHideDelay);this._prepareForPlay();this._lastPausedState=videoElem.paused}this._setOption("muted",videoElem.muted);this._refreshDuration();this._onVideoStateChangeId=setTimeout($.proxy(this._onVideoStateChange,this),this._const.VIDEO_STATE_TIMEOUT)},_updateTitleControlsTimeString:function(timeString,title){if(this._activeControlsIndex===1&&timeString){if(!title){title=timeString}$("span.ui-igplayer-playbutton-text",$("#"+this._id("_title_ctrls"))).attr("title",title).html(timeString)}},_analyzeSource:function(video,doNotShowError){var detected=false;if(this.supports_h264_baseline_video()&&video.data("mp4")!==undefined){video.attr("src",video.data("mp4"));detected=true}else if(this.supports_webm_video()&&video.data("webm")!==undefined){video.attr("src",video.data("webm"));detected=true}else if(this.supports_ogg_theora_video()){if(video.data("ogv")!==undefined){video.attr("src",video.data("ogv"));detected=true}else if(video.data("ogg")!==undefined){video.attr("src",video.data("ogg"));detected=true}}video.data("sourceDetected",detected);if(!detected&&!doNotShowError){this._showUnsupportedVideoSourceMsg();if(!this.options.browserControls){if(this._activeControlsIndex===0){$("#"+this._id("_ctrls_play")).igButton("option","disabled",true)}}}else{this._hideUnsupportedVideoSourceMsg();if(!this.options.browserControls){if(this._activeControlsIndex===0){$("#"+this._id("_ctrls_play")).igButton("option","disabled",false)}}}},resetCommercialsShow:function(){this._buildCommercialsShow();this._embeddedCommercialsShow=$.extend(true,[],this.options.commercials.embeddedCommercials);this._embeddedCommercialIndex=0},_attachVideoEvents:function(video){var control=this;this._videoEvents={error:function(event){control._onVideoError(event)},progress:function(event){control._onVideoLoading(event)},waiting:function(event){control._onVideoWaiting(event);control._waiting(this.currentSrc,this.currentTime,this.duration,event)},seeking:function(event){control._showWaitingIndicator()},seeked:function(event){control._hideWaitingIndicator()},timeupdate:function(event){control._changeCurrentTime(event)},ended:function(event){control._showCenterPlayButton().removeClass("ui-igplayer-centerplaybutton-pause").addClass("ui-igplayer-centerplaybutton-play");control._hideWaitingIndicator();if(!control.options.browserControls){$("span",$("#"+control._id("_ctrls_play"))).addClass("ui-icon-play").removeClass("ui-icon-pause")}$("#"+control._id("_ctrls_pb")).igProgressBar("option","value",0);if(control.options.relatedVideos.length>0){control._onControlMouseOut(null);$("#"+control._id("_rvcc")).show()}control._buildBannersShow();if(control.options.commercials.alwaysPlayCommercials){control.resetCommercialsShow()}control._ended(this.currentSrc,this.duration,event)},playing:function(event){control._hideWaitingIndicator();$("span",$("#"+control._id("_ctrls_play"))).addClass("ui-icon-pause").removeClass("ui-icon-play");control._playing(this.currentSrc,this.duration,event)},pause:function(event){$("span",$("#"+control._id("_ctrls_play"))).addClass("ui-icon-play").removeClass("ui-icon-pause");control._paused(this.currentSrc,this.duration,event)},click:function(event){var o=control.options;if(!o.browserControls){event.preventDefault()}if(event.button===0&&!o.disabled){control._onVideoClick(!o.browserControls)}},dblclick:function(event){event.preventDefault();if(event.button===0&&!control.options.disabled){control._onVideoDblClick()}},selectstart:function(){return false},loadedmetadata:function(event){control._refreshDuration()}};video.bind(this._videoEvents)},_onVideoClick:function(allowPlay){if(this._embeddedCommercialPlaying){var link=this.options.commercials.embeddedCommercials[this._embeddedCommercialIndex].link;if(link&&link.length>0){window.open(link,"_blank")}}else if(allowPlay){this.togglePlay()}},_onVideoDblClick:function(){var o=this.options;this._setOption("fullscreen",!o.fullscreen);if(!o.browserControls){this._toggleCenterPlayButton()}},_attachEvents:function(video){var control=this;this._attachVideoEvents(video);this._generalEvts={keydown:function(event){if(event.keyCode===$.ui.keyCode.ESCAPE){if(control.options.fullscreen){control._setOption("fullscreen",false);event.preventDefault();event.stopPropagation()}}else if(event.keyCode===$.ui.keyCode.SPACE){event.preventDefault();event.stopPropagation();control.togglePlay()}}};this._documentEvts={contextmenu:function(e){if($(e.target).is("video")&&control.options.disabled){e.preventDefault();e.stopPropagation()}}};$(document).bind(this._documentEvts);if(!this.options.browserControls){this._controlsEvts={mouseover:function(event){control._onControlMouseOver(event)},mouseout:function(event){control._onControlMouseOut(event)}};this.container.bind(this._controlsEvts)}this.container.bind(this._generalEvts)},_handleKbNavigation:function(event){if(event.keyCode===$.ui.keyCode.HOME){$(this.controlButtons[0]).focus();event.stopPropagation();event.preventDefault()}else if(event.keyCode===$.ui.keyCode.END){$(this.controlButtons[this.controlButtons.length-1]).focus();event.stopPropagation();event.preventDefault()}},_handleBlurKb:function(){this.currentVideo.removeClass(this.css.activeVideoClass)},_handleFocusKb:function(){this.currentVideo.addClass(this.css.activeVideoClass)},_onVideoLoading:function(event){this._detectBuffered(event)},_detectBuffered:function(event){var videoElem=this.currentVideo[0],buffered=videoElem.buffered,duration=parseInt(videoElem.duration,10),len=buffered?buffered.length:0,firstBuffered=len>0?parseInt(buffered.start(len-1),10):0,lastBuffered=len>0?parseInt(buffered.end(len-1),10):0,bufferSize=lastBuffered/duration*100;if(len>0&&this._previouslyBuffered!==bufferSize){if(this._previousBuffer&&lastBuffered<parseInt(this._previousBuffer.end(0),10)){$("#"+this._id("_ctrls_pb")).igProgressBar("option","value",firstBuffered)}$("#"+this._id("_ctrls_pb")).igProgressBar("option","endValue",lastBuffered/duration*100);this._buffering(videoElem.currentSrc,bufferSize,event);this._previouslyBuffered=bufferSize;this._previousBuffer=buffered}},_getActiveControls:function(){var ai=this._activeControlsIndex;if(ai!==undefined&&this.controls&&ai>=0&&ai<this.controls.length){return this.controls[ai].parent()}return null},_onControlMouseOver:function(){var controlsDiv=this._getActiveControls(),o=this.options;if(controlsDiv&&!o.browserControls&&o.autohide&&!$("#"+this._id("_rvcc")).is(":visible")){controlsDiv.show().removeClass(this.css.controlsHideClass)}},_onControlMouseOut:function(){var o=this.options,controlsDiv=this._getActiveControls();if(controlsDiv&&!o.browserControls&&o.autohide){controlsDiv.addClass(this.css.controlsHideClass).hide()}},_onVideoError:function(e){var error=e.target.error;switch(error.code){case error.MEDIA_ERR_ABORTED:break;case error.MEDIA_ERR_NETWORK:this.play();break;case error.MEDIA_ERR_DECODE:case error.MEDIA_ERR_SRC_NOT_SUPPORTED:this._showUnsupportedVideoSourceMsg();break;default:break}},_changeCurrentTime:function(event){var videoElem=this.currentVideo[0],rawDuration=videoElem.duration,currentTime;if(rawDuration===Infinity){this._updateProgressLabel()}else if(!isNaN(rawDuration)){currentTime=parseInt(videoElem.currentTime,10);if(!this._userSliding){$("#"+this._id("_ctrls_s")).igSlider("option","value",currentTime/rawDuration*100)}this._updateProgressLabel();if(this._embeddedCommercialPlaying){this._updateAdMessage(this.options.commercials.embeddedCommercials[this._embeddedCommercialIndex].endTime-currentTime);this._checkEmbeddedCommercialShow(currentTime)}else if(!this._commercialPlaying){this._checkBannerShow(currentTime);this._checkCommercialsShow(currentTime);this._checkEmbeddedCommercialShow(currentTime)}else{this._updateAdMessage(rawDuration-currentTime)}}this._progress(videoElem.currentSrc,currentTime,rawDuration,event)},_checkBannerShow:function(currentTime){var show=this._bannerShow||[],len=show.length,i=0;for(i;i<len;i++){if(show[i].length>0&&currentTime>=show[i][0]){show[i].shift();this.showBanner(i)}}},_checkCommercialsShow:function(currentTime){if(this._commercialsShow&&this._commercialsShow.length>0&&currentTime>=this._commercialsShow[0]&&!this._commercialPlaying){this._commercialPlaying=true;if(currentTime-this._commercialsShow[0]>this._const.COMMERCIAL_SEEK_DELTA){this.currentTime(this._commercialsShow[0])}this.playCommercial(this.options.commercials.linkedCommercials[this._commercialIndex])}},_checkEmbeddedCommercialShow:function(currentTime){if(this._embeddedCommercialsShow&&this._embeddedCommercialsShow.length>0&&!this.currentVideo[0].seeking){var currentCommercial=this._embeddedCommercialsShow[0];if(currentTime>=currentCommercial.startTime&&!this._embeddedCommercialPlaying){this._embeddedCommercialPlaying=true;if(currentTime-currentCommercial.startTime>this._const.COMMERCIAL_SEEK_DELTA){this.currentTime(currentCommercial.startTime)}$("#"+this._id("_ctrls_s")).igSlider("option","disabled",true);this._showAdMessage(currentCommercial.endTime-currentCommercial.startTime);if(currentCommercial.link&&currentCommercial.link.length>0){this.currentVideo.attr("title",$.ig.VideoPlayer.locale.adNewWindowTip)}}else if(currentTime>=currentCommercial.endTime&&this._embeddedCommercialPlaying){this._embeddedCommercialsShow.shift();this._embeddedCommercialIndex++;this._embeddedCommercialPlaying=false;this.hideAdMessage();$("#"+this._id("_ctrls_s")).igSlider("option","disabled",false);if(currentCommercial.link&&currentCommercial.link.length>0){this.currentVideo.removeAttr("title")}}}},_updateProgressLabel:function(){var videoElem=this.currentVideo[0],progressLabel=$("#"+this._id("_ctrls_pl")),rawDuration=videoElem.duration,duration=parseInt(rawDuration,10),currentTime=parseInt(videoElem.currentTime,10),progressString=this.options.progressLabelFormat;progressString=progressString.replace("${currentTime}",this._toTimeString(currentTime)).replace("${duration}",rawDuration===Infinity?$.ig.VideoPlayer.locale.liveStream:this._toTimeString(duration));progressLabel.html(progressString)},_toTimeString:function(val){if(typeof val==="number"){var secs=parseInt(val%60,10),mins=parseInt(val/60,10),hours=parseInt(mins/60,10),days=parseInt(hours/24,10),timeFormat="{0}d {1}:{2}:{3}";mins=parseInt(mins%60,10);hours=parseInt(hours%60,10);timeFormat=timeFormat.replace("{3}",secs<10?"0"+secs:secs).replace("{2}",mins);if(hours>0){timeFormat=timeFormat.replace("{1}",hours);if(days>0){timeFormat=timeFormat.replace("{0}",days)}else{timeFormat=timeFormat.replace("{0}d ","")}}else{timeFormat=timeFormat.replace("{0}d {1}:","")}return timeFormat}return"NaN"},_onVideoWaiting:function(){this._showWaitingIndicator()},_createUnsupportedVideoSourceMsg:function(){var css=this.css;return this._createButton(this._id("_detectError"),css.unsupportedVideoSourceClass,css.unsupportedVideoSourceIconClass,$.ig.VideoPlayer.locale.missingVideoSource).attr("title",$.ig.VideoPlayer.locale.unsupportedVideoSource)},_showUnsupportedVideoSourceMsg:function(){var error=$("#"+this._id("_detectError"));if(error.length===0){error=this._createUnsupportedVideoSourceMsg()}return error.show()},_hideUnsupportedVideoSourceMsg:function(){$("#"+this._id("_detectError")).hide()},_createBigPlayButton:function(){var control=this,css=this.css;this._createButton(this._id("_play"),css.centerPlayButtonClass,css.centerPlayButtonIconClass,"").bind({click:function(event){event.preventDefault();if(event.button===0){control._onVideoClick(true)}},dblclick:function(event){event.preventDefault();if(event.button===0){control._onVideoDblClick()}}})},_createButton:function(buttonId,buttonClass,spanClass,text){$("<span></span>").html(text).addClass(spanClass).appendTo($("<a></a>").attr("id",buttonId).attr("href",this._const.HREF).attr("tabIndex",-1).addClass("ui-state-default").addClass(buttonClass).appendTo(this.container));return $("#"+buttonId).bind({mouseover:function(){$(this).addClass("ui-state-hover")},mouseout:function(){$(this).removeClass("ui-state-hover")}}).hide()},_showCenterPlayButton:function(){var video=this.currentVideo,button=$("#"+this._id("_play")),videoCenterTop=Math.floor(video.height()/2),videoCenterLeft=Math.floor(video.width()/2),top=videoCenterTop-Math.floor(button.innerHeight()/2),left=videoCenterLeft-Math.floor(button.innerWidth()/2);button.css("position","absolute").css("left",left).css("top",top);return button.show()},_toggleCenterPlayButton:function(){var videoElem=this.currentVideo[0],o=this.options,css=this.css;if(videoElem.paused||videoElem.ended){this._showCenterPlayButton().removeClass(css.centerPauseButtonClass).addClass(css.centerPlayButtonClass)}else{this._showCenterPlayButton().removeClass(css.centerPlayButtonClass).addClass(css.centerPauseButtonClass)}setTimeout($.proxy(this._hideCenterPlayButton,this),o.centerButtonHideDelay)},_hideCenterPlayButton:function(){return $("#"+this._id("_play")).hide()},_createWaitingIndicator:function(){var css=this.css;this._createButton(this._id("_waiting"),css.waitingIndicatorClass,css.waitingIndicatorIconClass,$.ig.VideoPlayer.locale.buffering)},_createSeekTimeToolTip:function(){$("<div></div>").attr("id",this._id("_seek_tooltip")).hide().igTooltip({text:"00:00",arrowLocation:"bottom"}).appendTo(this.container).addClass(this.css.seekTooltipClass)},_showSeekTimeToolTip:function(x,y,seconds){var toolTip=$("#"+this._id("_seek_tooltip"));toolTip.css("top",y-toolTip.outerHeight()).css("left",x-toolTip.width()/2).igTooltip("option","text",this._toTimeString(seconds)).show()},_showWaitingIndicator:function(){if($("#"+this._id("_detectError")).is(":visible")){return}var video=this.currentVideo,button=$("#"+this._id("_waiting")),videoCenterTop=Math.floor(video.height()/2),videoCenterLeft=Math.floor(video.width()/2),top=videoCenterTop-Math.floor(button.innerHeight()/2),left=videoCenterLeft-Math.floor(button.innerWidth()/2);button.css("position","absolute").css("left",left).css("top",top).show()},_hideWaitingIndicator:function(){$("#"+this._id("_waiting")).hide()},_renderTitleControls:function(){var title=this.options.title,control=this,controlsDiv,html='<div id="'+this._id("_title_ctrls")+'" class="ui-widget-header ui-igplayer-controls ui-igplayer-grid ui-igplayer-title-controls ui-corner-all">';html+='<div class="ui-igplayer-row">';html+='<div class="ui-igplayer-container ui-igplayer-cell ui-igplayer-playback-alone">';html+='		<a id="'+this._id("_title_ctrls_play")+'" class="ui-button ui-igplayer-playbutton ui-igplayer-playback-with-time ui-state-default ui-corner-all ui-priority-primary" href="'+this._const.HREF+'">';html+='			<span title="'+$.ig.VideoPlayer.locale.play+'" class="ui-icon ui-icon-play ui-igplayer-playbutton-icon"></span>';html+='			<span title="00:00" class="ui-button-text ui-igplayer-playbutton-text">00:00</span>';html+="		</a>";html+="</div>";html+='<div id="'+this._id("_title_ctrls_t")+'" class="ui-igplayer-container ui-igplayer-cell ui-igplayer-video-title">';if(title&&title.length>0){html+=title}html+="</div></div></div>";controlsDiv=$(html).appendTo(this.container).wrap('<div style="position:absolute; width: 100%;"></div>');if(this.options.width){controlsDiv.parent().css("width",this.options.width)}$("#"+this._id("_title_ctrls_play")).bind({click:function(event){event.preventDefault();if(event.button===0&&!control.options.disabled){control.togglePlay()}}});return controlsDiv},_hideTitleControls:function(){if(this._activeControlsIndex!==0){this._activeControlsIndex=0;$("#"+this._id("_title_ctrls")).addClass(this.css.controlsHideClass).parent().remove();$("#"+this._id("_ctrls")).parent().show()}},_convertBookmarks:function(prop,bookmarks,duration,css){var len=bookmarks.length,newBookmarks=[],i=0,mark,newMark,value;for(i;i<len;i++){mark=bookmarks[i];if(mark[prop]>0&&mark[prop]<duration){value=parseInt(mark[prop]/duration*100,10);newMark={value:value,secondsValue:mark[prop],displayTime:this._toTimeString(mark[prop]),index:i,title:mark.title,disabled:mark.disabled};if(css&&css.length>0){newMark.css=css}newBookmarks.push(newMark)}}return newBookmarks},_renderBookmarks:function(){var o=this.options,bookmarks=o.bookmarks||[],com=o.commercials,ads=com.linkedCommercials||[],eads=com.embeddedCommercials||[],duration=this.currentVideo[0].duration,newBookmarks=[],newAdBookmarks=[],newEAdBookmarks=[];if(com.showBookmarks){if(ads.length>0){newAdBookmarks=this._convertBookmarks("startTime",ads,duration,this.css.linkedBookmarkClass)}if(eads.length>0){newEAdBookmarks=this._convertBookmarks("startTime",eads,duration,this.css.adBookmarkClass)}}if(bookmarks.length>0){newBookmarks=this._convertBookmarks("time",bookmarks,duration);if(newBookmarks.length>0){this._renderBookmarkArea(newBookmarks)}}if(newAdBookmarks.length>0){$.merge(newBookmarks,newAdBookmarks)}if(newEAdBookmarks.length>0){$.merge(newBookmarks,newEAdBookmarks)}if(newBookmarks.length>0){$("#"+this._id("_ctrls_s")).igSlider("option","bookmarks",newBookmarks)}this._bookmarksRendered=true},_renderBookmarkArea:function(bookmarks){if(bookmarks&&bookmarks.length>0){var css=this.css,bookmarkStr='<li class="ui-corner-all $class$"><span class="'+css.bookmarkItemTimeClass+'">11/6/2015 11:25:01 AM</span><span class="'+css.bookmarkItemTitleClass+'" title="$titleAttr$">$title$</span></li>',bookmarkAreaStr='<div id="$id$" class="$bookmarkContainerClass$"><div class="$headerClass$">$headerText$</div><ul class="$bookmarkListClass$">$list$</ul></div>',bookmarkList="",bookmarkArea,mark,i=0,len=bookmarks.length,control=this;for(i;i<len;i++){mark=bookmarks[i];bookmarkList+=bookmarkStr.replace("11/6/2015 11:25:01 AM",mark.displayTime).replace("$titleAttr$",mark.title).replace("$title$",mark.title).replace("$class$",mark.disabled?css.bookmarkItemDisabledClass:"")}bookmarkAreaStr=bookmarkAreaStr.replace("$id$",this._id("_bookmarks")).replace("$bookmarkContainerClass$",css.bookmarkContainerClass).replace("$headerClass$",css.bookmarkContainerHeaderClass).replace("$bookmarkListClass$",css.bookmarkListClass).replace("$headerText$",$.ig.VideoPlayer.locale.skipTo).replace("$list$",bookmarkList);bookmarkArea=$(bookmarkAreaStr).appendTo(this.container);this.bookmarkElements=$("li",$("#"+this._id("_bookmarks")));this.bookmarkElements.each(function(i){$(this).data("bookmark-index",bookmarks[i].index);$(this).data("bookmark-sec-value",bookmarks[i].secondsValue)});this.bookmarkElements.bind({click:function(event){var index=$(this).data("bookmark-index"),mark=control.options.bookmarks[index];event.stopPropagation();event.preventDefault();if(!mark.disabled){if(control.paused()){control.togglePlay()}control.currentTime($(this).data("bookmark-sec-value"));control._changeActiveBookmark(index);control._bookmarkClick(mark,bookmarks[index],event)}}});if(this.options.height){this.currentVideo.css("height",this.container.height()-bookmarkArea.height());this._resizeBookmarkAreaTimeoutId=setTimeout($.proxy(this._onPlayerResize,this),500)}}},_onPlayerResize:function(){var o=this.options,containerH=this.container.height(),containerW=this.container.width(),bookmarkArea=$("#"+this._id("_bookmarks"));if((o.height||o.width)&&(this._oldContainerHeight!==containerH||this._oldContainerWidth!==containerW)){this.currentVideo.css("height",containerH-bookmarkArea.height());this._oldContainerHeight=containerH;this._oldContainerWidth=containerW}this._resizeBookmarkAreaTimeoutId=setTimeout($.proxy(this._onPlayerResize,this),250)},_ensureVolume:function(){this.options.volume=this.currentVideo[0].volume},_renderControls:function(){$("body").addClass("ui-igplayer-normal-screen-mode");if(this.options.showSeekTime){this._createSeekTimeToolTip()}var videoElem=this.currentVideo[0],control=this,controlsDiv,controlsArray=[],autoPlay=this.options.autoplay,href=this._const.HREF,html='<div id="'+this._id("_ctrls")+'" class="$controlsClass$">',cachedTime;html+='			<div class="ui-igplayer-row">';html+='				<div class="ui-igplayer-container ui-igplayer-cell ui-igplayer-playback">';html+='					<a id="$playButtonId$" class="$playButtonClass$" href="'+href+'"></a>';html+="				</div>";html+='				<div class="ui-igplayer-container ui-igplayer-cell ui-igplayer-progress-bar">';html+='					<div id="$progressBarId$" class="$progressBarClass$"></div>';html+="				</div>";html+='				<div class="ui-igplayer-container ui-igplayer-extra">';html+='					<div class="ui-igplayer-grid">';html+='						<div class="ui-igplayer-row">';html+='							<div class="ui-igplayer-cell">';html+='								<a id="$progressLabelId$" class="$progressLabelClass$" href="'+href+'"></a>';html+="							</div>";html+='							<div class="ui-igplayer-cell">';html+="                               <div>";html+='								    <div id="$volumeSliderId$" class="$volumeSliderClass$"></div>';html+="									<div>";html+='										<a id="$volumeControlId$" class="$volumeControlClass$" href="'+href+'"></a>';html+="									</div>";html+="                               </div>";html+="							</div>";html+='							<div class="ui-igplayer-cell">';html+='								<a id="$fullScreenId$" class="$fullScreenClass$" href="'+href+'"></a>';html+="							</div>";html+="						</div>";html+="					</div>";html+="				</div>";html+="			</div>";html+="		</div>";html=html.replace("$playButtonClass$",this.css.playButtonClass).replace("$progressBarClass$",this.css.progressBarClass).replace("$fullScreenClass$",this.css.fullScreenClass).replace("$controlsClass$",this.css.controlsClass).replace("$volumeControlClass$",this.css.volumeControlClass).replace("$volumeSliderClass$",this.css.volumeSliderClass).replace("$progressLabelClass$",this.css.progressLabelClass);html=html.replace("$playButtonId$",this._id("_ctrls_play")).replace("$progressBarId$",this._id("_ctrls_s")).replace("$fullScreenId$",this._id("_ctrls_fs_btn")).replace("$volumeControlId$",this._id("_ctrls_vc_btn")).replace("$volumeSliderId$",this._id("_ctrls_vs")).replace("$progressLabelId$",this._id("_ctrls_pl"));controlsDiv=$(html).appendTo(this.container).wrap('<div style="position:absolute; width: 100%;"></div>');if(this.options.width){controlsDiv.parent().css("width",this.options.width)}controlsArray.push(controlsDiv);if(!autoPlay&&videoElem.currentTime===0){controlsDiv.parent().hide();this._activeControlsIndex=1;controlsArray.push(this._renderTitleControls())}else{this._activeControlsIndex=0}this.controls=$(controlsArray);$("#"+this._id("_ctrls_play")).bind({click:function(event){event.preventDefault();if(!$(this).igButton("option","disabled")){control.togglePlay()}}}).igButton({link:{href:this._const.HREF},css:{buttonLabelClass:"ui-icon "+(autoPlay?"ui-icon-pause ":"ui-icon-play ")+"ui-igplayer-playbutton-icon "}}).addClass("ui-priority-primary").attr("title",autoPlay?$.ig.VideoPlayer.locale.playing:$.ig.VideoPlayer.locale.paused);$("#"+this._id("_ctrls_fs_btn")).bind({click:function(event){event.preventDefault();control._setOption("fullscreen",!control.options.fullscreen)}}).igButton({link:{href:this._const.HREF},css:{buttonLabelClass:this.css.fullScreenIconClass}}).attr("title",$.ig.VideoPlayer.locale.enterFullscreen);$('<div id="'+this._id("_ctrls_pb")+'"></div>').appendTo($("#"+this._id("_ctrls_s")).igSlider({slide:function(event,ui){if(event.originalEvent===undefined){return false}clearTimeout(control._slideTimeout);control._slideTimeout=setTimeout(control._createDelegate(control,control._slide,[ui]),control._const.SLIDE_SEEK_TIMEOUT)},start:function(){control._userSliding=true},stop:function(){control._userSliding=false},bookmarkhit:function(event,ui){var index=ui.bookmark.index,elems=control.bookmarkElements;if(elems&&elems.length>0){control._changeActiveBookmark(index);control._bookmarkHit(control.currentVideo[0].currentSrc,control.options.bookmarks[index],elems[index],event)}},bookmarkclick:function(event,ui){var mark;if($(ui.bookmarkElement).hasClass("ui-igplayer-linked-bookmark")){mark=control.options.commercials.linkedCommercials[ui.bookmark.index]}else if($(ui.bookmarkElement).hasClass("ui-igplayer-ad-bookmark")){mark=control.options.commercials.embeddedCommercials[ui.bookmark.index]}else{mark=control.options.bookmarks[ui.bookmark.index];control._changeActiveBookmark(ui.bookmark.index)}if(mark.time){cachedTime=mark.time}else{cachedTime=mark.startTime}control.currentTime(cachedTime);control._bookmarkClick(mark,ui.bookmarkElement,event);return false},min:0,max:100,animate:true}).css("display","block")).igProgressBar({range:true,endValue:0});$("#"+this._id("_ctrls_pb")).bind({mousemove:function(e){if(control.options.showSeekTime&&this.offsetWidth>0){var relativeX=e.pageX-this.offsetLeft-$(this).offset().left,percentLocation=parseInt(relativeX/this.offsetWidth*100,10),duration=videoElem.duration,seconds,controlOffset=control.container.offset();if(!isNaN(duration)&&duration!==Infinity&&!control._commercialPlaying){seconds=parseInt(percentLocation*duration/100,10);control._showSeekTimeToolTip(e.pageX-controlOffset.left,e.pageY-controlOffset.top,seconds)}}},mouseout:function(){$("#"+control._id("_seek_tooltip")).hide()}});$("#"+this._id("_ctrls_pl")).bind({click:function(event){event.preventDefault()}});$("#"+this._id("_ctrls_vc_btn")).bind({mouseover:function(){control._showVolumeSlider()},mouseout:function(event){if(!jQuery.contains(event.currentTarget,event.relatedTarget)&&event.currentTarget!==event.relatedTarget){control._volumeSliderTimeoutId=setTimeout($.proxy(control._hideVolumeSlider,control),control.options.volumeAutohideDelay)}},click:function(event){event.preventDefault();control._setOption("muted",!control.options.muted)}}).igButton({link:{href:this._const.HREF},css:{buttonLabelClass:"ui-icon "+(this.options.muted?"ui-icon-volume-off ":"ui-icon-volume-on ")+"ui-igbutton-icon"}}).attr("title",$.ig.VideoPlayer.locale.volume);$("#"+this._id("_ctrls_vs")).hide().bind({mouseover:function(){control._volumeSliderMouseOut=false;clearTimeout(control._volumeSliderTimeoutId)},mouseout:function(){if(!control._userSlidingVolume){control._volumeSliderTimeoutId=setTimeout($.proxy(control._hideVolumeSlider,control),control.options.volumeAutohideDelay)}control._volumeSliderMouseOut=true}}).igSlider({slide:function(event,ui){if(event.originalEvent===undefined){return}control._setOption("volume",parseFloat(parseInt(ui.value,10)/100))},start:function(){control._userSlidingVolume=true},stop:function(){control._userSlidingVolume=false},min:0,max:100,step:10,orientation:"vertical",value:this.options.muted?0:this.options.volume*100});$("#"+this._id("_ctrls_vs")).data("igSlider").handle.attr("tabIndex",-1).bind({blur:function(){control._volumeSliderTimeoutId=setTimeout($.proxy(control._hideVolumeSlider,control),control.options.volumeAutohideDelay)}});this.controlButtons=$([document.getElementById(this._id("_ctrls_play")),$("a.ui-state-default",$("#"+this._id("_ctrls_s")))[0],document.getElementById(this._id("_ctrls_vc_btn")),document.getElementById(this._id("_ctrls_fs_btn"))]);this.controlButtons.each(function(i){$(this).data("index.control-button",i)});this.controlButtons.bind({keydown:function(event){control._handleKbNavigation(event)},focus:function(event){control._handleFocusKb(event)},blur:function(event){control._handleBlurKb(event)}});$("#"+this._id("_ctrls_vc_btn")).bind({focus:function(){control._showVolumeSlider()},blur:function(){if(!control._transferFocusFromVolumeButtonToVolumeSlider){control._hideVolumeSlider()}control._transferFocusFromVolumeButtonToVolumeSlider=false},keydown:function(event){if(event.keyCode===$.ui.keyCode.TAB){event.preventDefault();event.stopPropagation();control._transferFocusFromVolumeButtonToVolumeSlider=true;$("#"+control._id("_ctrls_vs")).data("igSlider").handle.focus()}}});$("#"+control._id("_ctrls_vs")).data("igSlider").handle.bind({keydown:function(event){if(event.keyCode===$.ui.keyCode.TAB){event.preventDefault();event.stopPropagation();$("#"+control._id("_ctrls_fs_btn")).focus()}}})},_slide:function(ui){var value=ui.value,rawDuration=this.currentVideo[0].duration,currentTime=rawDuration*(value/100);if(!isNaN(rawDuration)&&rawDuration!==Infinity){this.currentTime(currentTime)}this._userSliding=false},_changeActiveBookmark:function(index){var activeBookmarkIndex=this._activeBookmarkIndex,bkElems=this.bookmarkElements;if(bkElems&&bkElems.length>0&&index!==activeBookmarkIndex){if(activeBookmarkIndex>=0&&activeBookmarkIndex<bkElems.length){$(bkElems[activeBookmarkIndex]).removeClass(this.css.bookmarkActiveItemClass)}if(index>=0&&index<bkElems.length){$(bkElems[index]).addClass(this.css.bookmarkActiveItemClass);this._activeBookmarkIndex=index}}},_adjustVolumeButton:function(value){var volumeButton=$("#"+this._id("_ctrls_vc_btn"));if(value===0){$("span",volumeButton).removeClass("ui-icon-volume-on").addClass("ui-icon-volume-off")}else{$("span",volumeButton).removeClass("ui-icon-volume-off").addClass("ui-icon-volume-on")}},_hideVolumeSlider:function(){var slider=$("#"+this._id("_ctrls_vs"));slider.data("igSlider").handle.attr("tabIndex",-1);slider.hide()},_showVolumeSlider:function(){clearTimeout(this._volumeSliderTimeoutId);var slider=$("#"+this._id("_ctrls_vs"));slider.data("igSlider").handle.removeAttr("tabIndex");slider.show()},_ended:function(source,duration,event){var args={source:source,duration:duration};return this._trigger(this.events.ended,event,args)},_playing:function(source,duration,event){var args={source:source,duration:duration,currentTime:this.currentVideo[0].currentTime};return this._trigger(this.events.playing,event,args)},_paused:function(source,duration,event){var args={source:source,duration:duration,currentTime:this.currentVideo[0].currentTime};
return this._trigger(this.events.paused,event,args)},_buffering:function(source,bufferedPercent,event){var args={source:source,buffered:bufferedPercent};return this._trigger(this.events.buffering,event,args)},_progress:function(source,currentTime,duration,event){var args={source:source,currentTime:currentTime,duration:duration};return this._trigger(this.events.progress,event,args)},_waiting:function(source,currentTime,duration,event){var args={source:source,currentTime:currentTime,duration:duration};return this._trigger(this.events.waiting,event,args)},_bookmarkHit:function(source,bookmark,bookmarkElement,event){var args={source:source,bookmark:bookmark,bookmarkElement:bookmarkElement};return this._trigger(this.events.bookmarkHit,event,args)},_bookmarkClick:function(bookmark,bookmarkElement,event){var args={bookmark:bookmark,bookmarkElement:bookmarkElement};return this._trigger(this.events.bookmarkClick,event,args)},_enterFullScreen:function(source){var args={source:source};return this._trigger(this.events.enterFullScreen,null,args)},_exitFullScreen:function(source){var args={source:source};return this._trigger(this.events.exitFullScreen,null,args)},_bannerVisible:function(index,element){var args={index:index,banner:this.options.banners[index],bannerElement:element};return this._trigger(this.events.bannerVisible,null,args)},_bannerHidden:function(index,element){var args={index:index,banner:this.options.banners[index],bannerElement:element};return this._trigger(this.events.bannerHidden,null,args)},_prepareForPlay:function(){var o=this.options,video=this.currentVideo;if($("source",video).length===0){this._renderSources(o.sources,video)}if(!video.data("sourceDetected")){this._analyzeSource(video)}this._hideTitleControls();if(o.relatedVideos&&o.relatedVideos.length>0){$("#"+this._id("_rvcc")).hide()}},togglePlay:function(){var videoElem=this.currentVideo[0];this._prepareForPlay();this._toggleCenterPlayButton();if(videoElem.paused||videoElem.ended){if(!this.options.browserControls){$("#"+this._id("_ctrls_play")).attr("title",$.ig.VideoPlayer.locale.playing)}videoElem.play()}else{if(!this.options.browserControls){$("#"+this._id("_ctrls_play")).attr("title",$.ig.VideoPlayer.locale.paused)}videoElem.pause()}},play:function(){var videoElem=this.currentVideo[0];if(videoElem.paused||videoElem.ended){this._prepareForPlay();this._toggleCenterPlayButton();if(!this.options.browserControls){$("#"+this._id("_ctrls_play")).attr("title",$.ig.VideoPlayer.locale.playing)}videoElem.play()}},pause:function(){var videoElem=this.currentVideo[0];if(!videoElem.paused){this._toggleCenterPlayButton();if(!this.options.browserControls){$("#"+this._id("_ctrls_play")).attr("title",$.ig.VideoPlayer.locale.paused)}videoElem.pause()}},currentTime:function(val){var videoElem=this.currentVideo[0],rawDuration=videoElem.duration;if(val!==null&&val!==undefined){try{videoElem.currentTime=val;$("#"+this._id("_ctrls_pb")).igProgressBar("option","value",(val/rawDuration).toFixed(2)*100);this._checkCommercialsShow(val);this._checkEmbeddedCommercialShow(val)}catch(ex){}if(videoElem.paused&&!isNaN(rawDuration)){$("#"+this._id("_ctrls_s")).igSlider("option","value",(val/rawDuration).toFixed(2)*100)}}return parseInt(videoElem.currentTime,10)},screenshot:function(scaleFactor){if(!scaleFactor||$.type(scaleFactor)!=="number"){scaleFactor=1}var videoElem=this.currentVideo[0],w=videoElem.videoWidth*scaleFactor,h=videoElem.videoHeight*scaleFactor,canvas=document.createElement("canvas"),ctx;if(canvas.getContext){canvas.width=w;canvas.height=h;ctx=canvas.getContext("2d");ctx.drawImage(videoElem,0,0,w,h)}return canvas},supports_video:function(){return!!document.createElement("video").canPlayType},supports_h264_baseline_video:function(){if(!this.supports_video()){return false}var v=document.createElement("video");return v.canPlayType('video/mp4; codecs="avc1.42E01E, mp4a.40.2"')!==""},supports_ogg_theora_video:function(){if(!this.supports_video()){return false}var v=document.createElement("video");return v.canPlayType('video/ogg; codecs="theora, vorbis"')!==""},supports_webm_video:function(){if(!this.supports_video()){return false}var v=document.createElement("video");return v.canPlayType('video/webm; codecs="vp8, vorbis"')!==""},paused:function(){return this.currentVideo[0].paused},ended:function(){return this._getMainVideo()[0].ended},duration:function(){this._refreshDuration();return this._duration},_refreshDuration:function(){var duration=this.currentVideo[0].duration;if(duration!==this._duration){this._duration=duration;if(duration===Infinity){this._updateTitleControlsTimeString($.ig.VideoPlayer.locale.live,$.ig.VideoPlayer.locale.liveStream);$("#"+this._id("_ctrls_s")).data("igSlider").handle.hide();$("#"+this._id("_ctrls_s")).igSlider("option","disabled",true)}else if(!isNaN(duration)){if(this._commercialPlaying){this._showAdMessage(parseInt(duration,10))}else{this._updateTitleControlsTimeString(this._toTimeString(duration));if(!this._bookmarksRendered&&duration>0){this._renderBookmarks()}}}}},seeking:function(){return this.currentVideo[0].seeking},destroy:function(){var css=this.css;clearTimeout(this._scrollingTimoutId);clearTimeout(this._volumeSliderTimeoutId);clearTimeout(this._onVideoStateChangeId);clearTimeout(this._resizeBookmarkAreaTimeoutId);if(this._oldWidth){this.element.css("width",this._oldWidth)}if(this._oldHeight){this.element.css("height",this._oldHeight)}this.container.unbind(this._generalEvts);$(document).unbind(this._documentEvts);if(this._controlsEvts){this.container.unbind(this._controlsEvts)}this.container.removeClass(css.baseClasses);$("#"+this._id("_ctrls_s")).igSlider("destroy");$("#"+this._id("_ctrls_pb")).igProgressBar("destroy");$("#"+this._id("_ctrls_vs")).igSlider("destroy");$("#"+this._id("_seek_tooltip")).igTooltip("destroy");if(this._commercialsShow){delete this._commercialsShow;delete this._commercialIndex;delete this._commercialPlaying}if(this._embeddedCommercialsShow){delete this._embeddedCommercialPlaying;delete this._embeddedCommercialIndex;delete this._embeddedCommercialsShow}delete this.bookmarkElements;delete this.relatedVideoElements;delete this.controlButtons;delete this._bannerShow;delete this.banner;if(this.element.is("video")){this.element.unbind(this._videoEvents);this.element.removeClass(css.videoClass);this._restoreExistingVideoProperties(this.element);$(":not(video)",this.container).remove();this.element.unwrap()}else{this.container.children().remove()}$.Widget.prototype.destroy.apply(this,arguments)},_destroyBookmarks:function(){if(this.bookmarkElements&&this.bookmarkElements.length>0){this.bookmarkElements.unbind();this.bookmarkElements.removeData();delete this.bookmarkElements;$("#"+this._id("_bookmarks")).remove();$("#"+this._id("_ctrls_s")).igSlider("clearBookmarks");this._bookmarksRendered=false}},_destroyRelatedVideos:function(){var related=this.options.relatedVideos;if(related&&related.length>0){$("#"+this._id("_rvcc")).remove();delete this.relatedVideoElements;related=[]}},_destroyControls:function(){var controls=this.options.browserControls;if(!controls){$("#"+this._id("_ctrls_play")).igButton("destroy");$("#"+this._id("_ctrls_vc_btn")).igButton("destroy");$("#"+this._id("_ctrls_fs_btn")).igButton("destroy");$("#"+this._id("_ctrls_pb")).igProgressBar("destroy");$("#"+this._id("_ctrls_s")).igSlider("destroy");$("#"+this._id("_ctrls_vs")).igSlider("destroy");this.controls.each(function(){$(this).parent().remove()});delete this.controls;delete this.controlButtons;delete this._activeControlsIndex}}});$.extend($.ui.igVideoPlayer,{version:"13.1.20131.2523"})})(jQuery);