﻿namespace RestUpdatingSample.Controllers
{
    using System.Linq;
    using System.Net;
    using System.Net.Http;
    using System.Web.Http;
    using Models;

    public class UsersController : ApiController
    {
        private readonly IRepository<User> data;

        public UsersController()
        {
            data = new EfRepository<User>(new DatabaseEntities());
        }

        // GET api/<controller>
        public IQueryable<UserModel> Get()
        {
            var users = this.data.All().Select(UserModel.FromUser());

            return users;
        }



        // GET api/<controller>/5
        public HttpResponseMessage Get(int id)
        {
            var user = this.data.All().Where(u => u.Id == id)
                          .Select(UserModel.FromUser());

            if (user == null)
            {
                return this.Request.CreateErrorResponse(HttpStatusCode.NotFound, "Item not found!");
            }

            return this.Request.CreateResponse(HttpStatusCode.OK, user);
        }

        // POST api/<controller>
        public void Post([FromBody] string value)
        {

        }

        // PUT api/<controller>/5
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/<controller>/5
        public void Delete(int id)
        {
        }
    }
}