﻿Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports Infragistics.Web.UI.EditorControls
Imports Infragistics.Web.UI.LayoutControls
Imports Infragistics.Web.UI

Public Class GenerateScreen
    Public Shared Sub ScreenContents(ByRef MainHolderControl As Control)
        Dim htmlTableInsideMainTab As WebControls.Table
        Dim webTabMain As WebTab
        Dim myContentTabItemMain As ContentTabItem

        ' Make sure there is nothing already in the control that will house our dynamically generated HTML / aspx controls
        MainHolderControl.Controls.Clear()

        ' create Main tab control
        webTabMain = New WebTab()
        webTabMain.ID = "WebTabMain"
        webTabMain.Width = New Unit(100, UnitType.Percentage)
        webTabMain.AutoPostBackFlags.SelectedIndexChanged = AutoPostBackFlag.On
        webTabMain.StyleSetName = "RedPlanet"
        webTabMain.BorderStyle = BorderStyle.None
        webTabMain.BorderWidth = 0
        MainHolderControl.Controls.Add(webTabMain)

        ' add tabs to the Main tab control
        If webTabMain.Tabs.Count = 0 Then
            For TabIndex As Integer = 0 To TestData.NumMainTabs
                myContentTabItemMain = New ContentTabItem()
                myContentTabItemMain.Key = "MainContentTabItem" & TabIndex.ToString()
                webTabMain.Tabs.Add(myContentTabItemMain)
                myContentTabItemMain.Text = "MainTab" & TabIndex.ToString()
                myContentTabItemMain.AutoSize = False
                myContentTabItemMain.EnableAjax = False
                myContentTabItemMain.ViewStateMode = ViewStateMode.Enabled
            Next
        End If
        ' select the proper tab
        webTabMain.SelectedIndex = TestData.SelectedMainTabIndex

        ' Render the contents of the Main tab that is being displayed
        myContentTabItemMain = webTabMain.Tabs(webTabMain.SelectedIndex)

        ' we arrange things inside the Main tab using HTML tables
        htmlTableInsideMainTab = New WebControls.Table
        htmlTableInsideMainTab.ID = "HtmlTableInsideMainTab" & TestData.SelectedMainTabIndex.ToString()
        htmlTableInsideMainTab.Width = New Unit("100", UnitType.Percentage)
        htmlTableInsideMainTab.CssClass = "htmlTableWithPadding"
        htmlTableInsideMainTab.BorderStyle = BorderStyle.None
        htmlTableInsideMainTab.BorderWidth = 0
        myContentTabItemMain.Controls.Add(htmlTableInsideMainTab)

        CreateSubTabs(htmlTableInsideMainTab)
    End Sub

    Protected Shared Sub CreateSubTabs(ByRef HtmlTableInsideMasterTab As WebControls.Table)
        Dim htmlTableInsideSubTab As WebControls.Table
        Dim myTableRow As TableRow
        Dim myTableCell As TableCell
        Dim webTabSub As WebTab
        Dim myContentTabItemSub As ContentTabItem

        ' create a new table row and table cell in the master tab to hold the sub tab control
        myTableRow = New TableRow
        myTableCell = New TableCell
        ' create the common tab control
        webTabSub = New WebTab
        webTabSub.ID = "WebTabSub"
        webTabSub.Width = New Unit(100, UnitType.Percentage)
        webTabSub.AutoPostBackFlags.SelectedIndexChanged = AutoPostBackFlag.On
        webTabSub.StyleSetName = "RedPlanet"
        webTabSub.BorderStyle = BorderStyle.None
        webTabSub.BorderWidth = 0
        ' insert the sub tab control in the cell, insert the cell in the row, and insert the row in the table that is inside the master tab
        myTableCell.Controls.Add(webTabSub)
        myTableRow.Controls.Add(myTableCell)
        HtmlTableInsideMasterTab.Controls.Add(myTableRow)

        ' add each of the tabs to the sub tab control
        For TabIndex As Integer = 0 To TestData.NumSubTabs
            myContentTabItemSub = New ContentTabItem()
            myContentTabItemSub.Key = "SubContentTabItem" & TabIndex.ToString()
            webTabSub.Tabs.Add(myContentTabItemSub)
            myContentTabItemSub.Text = "SubTab" & TabIndex.ToString()
            myContentTabItemSub.AutoSize = DefaultableBoolean.True
            myContentTabItemSub.EnableAjax = False
            myContentTabItemSub.ViewStateMode = ViewStateMode.Enabled
        Next

        webTabSub.SelectedIndex = TestData.SelectedSubTabIndex

        ' create another HTML table to hold the contents of the sub tab
        htmlTableInsideSubTab = New WebControls.Table
        htmlTableInsideSubTab.ID = "HtmlTableInsideSubTab" & TestData.SelectedSubTabIndex.ToString()
        htmlTableInsideSubTab.Width = New Unit("100", UnitType.Percentage)
        htmlTableInsideSubTab.BorderStyle = BorderStyle.None
        htmlTableInsideSubTab.BorderWidth = 0
        webTabSub.Tabs(TestData.SelectedSubTabIndex).Controls.Add(htmlTableInsideSubTab)

        ' put fields in the sub tab
        LayoutFieldsInSubTab(htmlTableInsideSubTab)
    End Sub

    Protected Shared Sub LayoutFieldsInSubTab(ByRef HtmlTableInsideSubTab As WebControls.Table)
        Dim myTableRow As TableRow
        Dim myTableCellLabel As TableCell
        Dim myTableCellTextBox As TableCell
        Dim myLabel As Label
        Dim myTextBox As TextBox

        For Each myDataColumn As DataColumn In TestData.LastDataTable.Columns
            myTableRow = New TableRow
            myTableCellLabel = New TableCell
            myTableCellTextBox = New TableCell
            myLabel = New Label
            myLabel.ID = "lbl" & myDataColumn.ColumnName
            myLabel.Text = myDataColumn.ColumnName
            myTableCellLabel.Controls.Add(myLabel)
            myTextBox = New TextBox
            myTextBox.ID = "txt" & myDataColumn.ColumnName
            myTableCellTextBox.Controls.Add(myTextBox)
            myTableRow.Controls.Add(myTableCellLabel)
            myTableRow.Controls.Add(myTableCellTextBox)
            HtmlTableInsideSubTab.Controls.Add(myTableRow)
        Next
    End Sub
End Class
