﻿Imports System.Web.UI

''' <summary>
''' Utilities for screen layout
''' </summary>
''' <remarks></remarks>
Public NotInheritable Class UtilitiesLayout
    ''' <summary>
    ''' This function walks through the controls collection, and all children controls colelctions, to find a control specified by a control ID
    ''' </summary>
    ''' <param name="control"></param>
    ''' <param name="id"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function FindControlRecursive(ByVal control As Control, ByVal id As String) As Control
        Dim returnControl As Control = control.FindControl(id)
        If returnControl Is Nothing Then
            For Each child As Control In control.Controls
                returnControl = FindControlRecursive(child, id)
                If returnControl IsNot Nothing AndAlso returnControl.ID = id Then
                    Return returnControl
                End If
            Next
        End If
        Return returnControl
    End Function
End Class
