﻿Imports System.Diagnostics
Imports Infragistics.Web.UI.EditorControls
Imports Infragistics.Web.UI.LayoutControls
Imports Infragistics.Web.UI.GridControls
Imports System.Data

Public Class WebForm2
    Inherits System.Web.UI.Page

    Dim _webTabMain As WebTab
    Dim _webTabSub As WebTab
    Dim blnDataChanged As Boolean = False

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            ' first screen
            ' generate some test data for the current main tab and sub tab
            TestData.GetDataTable(WebDataGrid1.Behaviors.Paging.PageIndex)
            blnDataChanged = True
        End If
        ' reconstruct existing screen so that we can read existing values
        GenerateMainScreen()
        ' clear previous value
        txtTextBoxValues.Text = String.Empty
    End Sub

    Private Sub Page_PreRender(sender As Object, e As System.EventArgs) Handles Me.PreRender
        If blnDataChanged Then
            ' generate some test data for the current main tab, sub tab, and page of data
            TestData.GetDataTable(WebDataGrid1.Behaviors.Paging.PageIndex)
            ' in this example - since the data changed - the fields in the tabs changed - so we have to load the new fields in the tabs (regenerate the screen)
            GenerateMainScreen()
            ' I think we have to bind the data to the webdatagrid so that it will force the custom data binding event to be raised
            ClearDataGrid()
            WebDataGrid1.DataSource = TestData.LastDataTable
            WebDataGrid1.DataBind()
            SetCurrentRecord()
            SetWebDataGridIndex()
        End If
        ' we only show the button on certain tabs
        If _webTabMain.SelectedIndex = 1 Then
            WebDataGrid1.Columns(0).Hidden = True
        Else
            WebDataGrid1.Columns(0).Hidden = False
        End If
    End Sub

    Protected Sub GenerateMainScreen()
        ' update items that are not dynamically generated
        lblRecordCount.Text = "of " + TestData.NumRows.ToString()

        ' generate the main screen
        GenerateScreen.ScreenContents(PanelMainHolderControl)

        ' find the main controls we work with
        _webTabMain = UtilitiesLayout.FindControlRecursive(PanelMainHolderControl, "WebTabMain")
        _webTabSub = UtilitiesLayout.FindControlRecursive(PanelMainHolderControl, "WebTabSub")

        ' hook up change events like user changing tabs
        If _webTabMain IsNot Nothing Then
            AddHandler _webTabMain.SelectedIndexChanged, AddressOf WebTabMain_SelectedIndexChanged
        End If
        If _webTabSub IsNot Nothing Then
            AddHandler _webTabSub.SelectedIndexChanged, AddressOf WebTabSub_SelectedIndexChanged
        End If
    End Sub

    Protected Sub WebTabMain_SelectedIndexChanged(ByVal sender As Object, ByVal e As TabSelectedIndexChangedEventArgs)
        TestData.SelectedMainTabIndex = e.NewIndex
        WebDataGrid1.Behaviors.Paging.PageIndex = 1
        blnDataChanged = True
    End Sub

    Protected Sub WebTabSub_SelectedIndexChanged(ByVal sender As Object, ByVal e As TabSelectedIndexChangedEventArgs)
        TestData.SelectedSubTabIndex = e.NewIndex
        WebDataGrid1.Behaviors.Paging.PageIndex = 1
        blnDataChanged = True
    End Sub

    Sub ClearOnScreenFields()
        Dim myTextBox As TextBox

        ' there are times when we need to clear the textboxes on the screen
        For Each myDataColumn As DataColumn In TestData.LastDataTable.Columns
            myTextBox = UtilitiesLayout.FindControlRecursive(PanelMainHolderControl, "txt" & myDataColumn.ColumnName)
            If myTextBox IsNot Nothing Then
                myTextBox.Text = String.Empty
            End If
        Next
    End Sub

#Region "Web Data Grid"
    ''' <summary>
    ''' Handles the RowSelectionChanged event of the WebDataGrid1 control.
    ''' </summary>
    ''' <param name="sender">The source of the event.</param>
    ''' <param name="e">The <see cref="Infragistics.Web.UI.GridControls.SelectedRowEventArgs" /> instance containing the event data.</param>
    Protected Sub WebDataGrid1_RowSelectionChanged(sender As Object, e As Infragistics.Web.UI.GridControls.SelectedRowEventArgs) Handles WebDataGrid1.RowSelectionChanged
        Dim selectedRow As GridRecord = e.CurrentSelectedRows(0)

        ' we want to synchronize the data grid and the detailed view
        If (TestData.LastDataTable IsNot Nothing) AndAlso (selectedRow IsNot Nothing) Then
            TestData.CurrentRecordNumber = selectedRow.Index
            SetCurrentRecord()

            ' Enable or disable buttons
            If (TestData.CurrentRecordNumber > 0) Then
                ImageButtonPreviousRecord.Enabled = True
            Else
                ImageButtonPreviousRecord.Enabled = False
            End If
            If (TestData.CurrentRecordNumber < TestData.LastDataTable.Rows.Count - 1) Then
                ImageButtonNextRecord.Enabled = True
            Else
                ImageButtonNextRecord.Enabled = False
            End If
            blnDataChanged = True
        End If
    End Sub

    ''' <summary>
    ''' Sets the index of the web data grid.
    ''' </summary>
    Protected Sub SetWebDataGridIndex()
        WebDataGrid1.Behaviors.Selection.SelectedRows.Clear()
        WebDataGrid1.Behaviors.Selection.SelectedRows.Add(WebDataGrid1.Rows(TestData.CurrentRecordNumber))
    End Sub

    Protected Sub ClearDataGrid()
        ' Evidently the Infragistics web data grid has to be cleared in special ways or bad things can happen
        ' http://www.infragistics.com/community/forums/t/57084.aspx
        '
        ' NOTE - it has something to do with rendering the grid without a datasource.  So in other sections of the code - I change the WebDataGrid.Visible on and off
        '
        WebDataGrid1.Behaviors.Selection.SelectedRows.Clear()
        WebDataGrid1.Behaviors.Selection.SelectedCells.Clear()
        WebDataGrid1.Rows.Clear()
        WebDataGrid1.ClearDataSource()
        WebDataGrid1.DataSource = Nothing
        WebDataGrid1.DataBind()
        WebDataGrid1.DataKeyFields = String.Empty
        WebDataGrid1.Visible = False
    End Sub

    Protected Sub WebDataGrid1_CustomDataBinding(sender As Object, e As Infragistics.Web.UI.GridControls.DataBindingEventArgs) Handles WebDataGrid1.CustomDataBinding
        Dim currentPage As Integer = WebDataGrid1.Behaviors.Paging.PageIndex
        Dim pageSize As Integer = WebDataGrid1.Behaviors.Paging.PageSize
        Dim startIndex As Integer = currentPage * pageSize
        Dim blnAbleToBindData As Boolean = False

        ' data changes based on searching 
        ' custom data binding was used because (a) we have separate data layers (b) for paging - one page of data is loaded from data layer on every page change
        ' http://www.infragistics.com/products/aspnet/sample/data-grid/custom-databinding-paging-collection
        ' many pre tests (checking that we have search query, making we get search results, etc) are skipped here
        WebDataGrid1.ScrollTop = 0
        WebDataGrid1.Behaviors.Paging.PageSize = TestData.GridPageSize
        TestData.GetDataTable(WebDataGrid1.Behaviors.Paging.PageIndex)
        e.DataSource = TestData.LastDataTable
        e.SelectArguments.TotalRowCount = TestData.NumRows
        blnAbleToBindData = True
        WebDataGrid1.Visible = True
        e.Cancel = True
    End Sub

    Protected Sub WebDataGrid1_ItemCommand(sender As Object, e As Infragistics.Web.UI.GridControls.HandleCommandEventArgs) Handles WebDataGrid1.ItemCommand
        ' for some main and sub tab combinations - we have a button visible in the data grid that pops up an image of a document associated with the data grid row
        lblDocumentViewer.Text = "This simulates a Document Viewer for DocumentID = " + e.CommandArgument
        Me.WebDialogWindow1.WindowState = Infragistics.Web.UI.LayoutControls.DialogWindowState.Normal
    End Sub

    Protected Sub WebDataGrid1_InitializeRow(sender As Object, e As Infragistics.Web.UI.GridControls.RowEventArgs) Handles WebDataGrid1.InitializeRow
        Dim btnView As Button

        ' we do a couple of things - not shown in this example - during InitializeRow event hander
        If (e.Row.DataItem IsNot Nothing) Then
            ' assign the primary key value to the btnView command argument so that when the user clicks the button - the button posts back with the primary key value
            btnView = e.Row.Items(0).FindControl("btnView")
            If btnView IsNot Nothing Then
                btnView.CommandArgument = TestData.LastDataTable.Rows(e.Row.Index)(0).ToString()
            End If
        End If
    End Sub
#End Region

#Region "Buttons"
    Protected Sub btnTestPopupWindow_Click(sender As Object, e As EventArgs) Handles btnTestPopupWindow.Click
        ' this is redundant test of WebDataGrid1_ItemCommand()
        Me.WebDialogWindow1.WindowState = Infragistics.Web.UI.LayoutControls.DialogWindowState.Normal
    End Sub

    Protected Sub btnSearch_Click(sender As Object, e As EventArgs) Handles btnSearch.Click
        txtTextBoxValues.Text = String.Empty
        Dim myTextBox As TextBox

        ' this is a test to see if we can read the values that were entered on the screen
        For Each myDataColumn As DataColumn In TestData.LastDataTable.Columns
            myTextBox = UtilitiesLayout.FindControlRecursive(PanelMainHolderControl, "txt" & myDataColumn.ColumnName)
            If myTextBox IsNot Nothing Then
                txtTextBoxValues.Text &= myDataColumn.ColumnName & " = " & myTextBox.Text & ControlChars.CrLf
            End If
        Next
    End Sub
#End Region

#Region "Navigation controls"
    Protected Sub SetCurrentRecord()
        Dim myTextBox As TextBox

        If TestData.LastDataTable IsNot Nothing Then
            WebDataGrid1.Visible = True
            If TestData.CurrentRecordNumber < TestData.NumRows Then
                If TestData.CurrentRecordNumber < TestData.LastDataTable.Rows.Count Then
                    txtCurrentRecordNum.Text = (TestData.CurrentRecordNumber + 1).ToString()

                    ' Set the results of all the fields
                    For Each myDataColumn As DataColumn In TestData.LastDataTable.Columns
                        myTextBox = UtilitiesLayout.FindControlRecursive(PanelMainHolderControl, "txt" & myDataColumn.ColumnName)
                        If myTextBox IsNot Nothing Then
                            myTextBox.Text = TestData.LastDataTable.Rows(TestData.CurrentRecordNumber)(myDataColumn.ColumnName).ToString()
                        End If
                    Next
                End If
            End If
        End If
    End Sub

    Protected Sub ImageButtonStart_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonStart.Click
        TestData.CurrentRecordNumber = 0
        ImageButtonPreviousRecord.Enabled = False
        ImageButtonNextRecord.Enabled = True
        blnDataChanged = True
    End Sub

    Protected Sub ImageButtonPreviousPage_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonPreviousPage.Click
    End Sub

    Protected Sub ImageButtonPreviousRecord_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonPreviousRecord.Click
        If TestData.CurrentRecordNumber > 0 Then
            TestData.CurrentRecordNumber -= 1
            If (TestData.CurrentRecordNumber > 0) Then
                ImageButtonPreviousRecord.Enabled = True
            Else
                ImageButtonPreviousRecord.Enabled = False
            End If
            ImageButtonNextRecord.Enabled = True
            blnDataChanged = True
        End If
    End Sub

    Protected Sub ImageButtonNextRecord_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonNextRecord.Click
        If TestData.CurrentRecordNumber < TestData.NumRows - 1 Then
            TestData.CurrentRecordNumber += 1
            If (TestData.CurrentRecordNumber < TestData.NumRows - 1) Then
                ImageButtonNextRecord.Enabled = True
            Else
                ImageButtonNextRecord.Enabled = False
            End If
            ImageButtonPreviousRecord.Enabled = True
            blnDataChanged = True
        End If
    End Sub

    Protected Sub ImageButtonNextPage_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonNextPage.Click
        If TestData.CurrentRecordNumber < TestData.NumRows - 1 Then
            If TestData.CurrentRecordNumber + TestData.GridPageSize < TestData.NumRows - 1 Then
                TestData.CurrentRecordNumber += TestData.GridPageSize
                If (TestData.CurrentRecordNumber < TestData.NumRows - 1) Then
                    ImageButtonNextRecord.Enabled = True
                Else
                    ImageButtonNextRecord.Enabled = False
                End If
                ImageButtonPreviousRecord.Enabled = True
            Else
                ImageButtonEnd_Click(Nothing, Nothing)
            End If
            blnDataChanged = True
        End If
    End Sub

    Protected Sub ImageButtonEnd_Click(sender As Object, e As System.Web.UI.ImageClickEventArgs) Handles ImageButtonEnd.Click
        TestData.CurrentRecordNumber = TestData.NumRows - 1
        ImageButtonPreviousRecord.Enabled = True
        ImageButtonNextRecord.Enabled = False
        blnDataChanged = True
    End Sub
#End Region

End Class