﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Json;
using Infragistics.Controls.Grids;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Infragistics;

namespace SilverlightApplication1
{
    public partial class MainPage : UserControl
    {
        List<Dictionary<string, int>> _testData = new List<Dictionary<string, int>>();

        public MainPage()
        {
            InitializeComponent();

            Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            string jsonString = "[{\"Name\":\"John Doe\", \"Email\":\"johnd@hotmail.com\", \"ID\":1.0},{\"Name\":\"Mary Doe\", \"Email\":\"maryd@hotmail.com\", \"ID\":2.0}]";
            var dataSource = JsonConvert.DeserializeObject<List<Dictionary<string, object>>>(jsonString);

            // create the columns
            foreach (KeyValuePair<string, object> v in dataSource[0])
            {
                if (xamGrid1.Columns["[" + v.Key + "]"] == null)
                {
                    TextColumn tc = new TextColumn { Key = "[" + v.Key + "]", HeaderText = v.Key };
                    if (v.Value.GetType() == typeof(double) || v.Value.GetType() == typeof(long) || v.Value.GetType() == typeof(int))
                        tc.SummaryColumnSettings.SummaryOperands.Add(new JsonSumOperand());

                    xamGrid1.Columns.Add(tc);
                }
            }

            xamGrid1.ItemsSource = dataSource;
        }

        string StripQuotes(string jsonValue)
        {
            if (jsonValue[0] == '\"' && jsonValue[jsonValue.Length - 1] == '\"')
            {
                jsonValue = jsonValue.Remove(jsonValue.Length - 1, 1);
                jsonValue = jsonValue.Remove(0, 1);
                return jsonValue;
            }

            return jsonValue;
        }
    }

    public class JsonSumSummaryCalc : SynchronousSummaryCalculator
    {
        public override SummaryExecution? SummaryExecution
        {
            get
            {
                return Infragistics.SummaryExecution.PriorToFilteringAndPaging;
            }
        }

        public override object Summarize(IQueryable data, string fieldKey)
        {
            double sum = 0.0;

            foreach (var item in data)
            {
                Dictionary<string, object> properties = (Dictionary<string, object>)item;
                sum += (double)properties[fieldKey.Replace("[", "").Replace("]", "")];
            }

            return sum;
        }
    }

    public class JsonSumOperand : SummaryOperandBase
    {
        JsonSumSummaryCalc myCalc;

        protected override string DefaultRowDisplayLabel
        {
            get { return "Sum"; }
        }
        protected override string DefaultSelectionDisplayLabel
        {
            get { return "Sum"; }
        }

        public override SummaryCalculatorBase SummaryCalculator
        {
            get
            {
                if (myCalc == null)
                    myCalc = new JsonSumSummaryCalc();

                return myCalc;
            }
        }
    }
}
