﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace SampleData
{
    public class Category : INotifyPropertyChanged
    {
        private int _categoryId;
        private string _categoryName;
        private string _description;
        private ObservableCollection<Product> _products;

        public int CategoryID
        {
            get
            {
                return this._categoryId;
            }
            set
            {
                if (this._categoryId != value)
                {
                    this._categoryId = value;
                }
            }
        }

        public string CategoryName
        {
            get
            {
                return this._categoryName;
            }
            set
            {
                if (this._categoryName != value)
                {
                    this._categoryName = value;
                    OnPropertyChanged("CategoryName");
                }
            }
        }

        public string Description
        {
            get
            {
                return this._description;
            }
            set
            {
                if (this._description != value)
                {
                    this._description = value;
                    OnPropertyChanged("Description");
                }
            }
        }

        public ObservableCollection<Product> Products
        {
            get
            {
                if (_products == null)
                {
                    _products = new ObservableCollection<Product>();
                }

                return this._products;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }

    public class Product : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private int _productId;
        private string _productName;
        private int _categoryId;
        private string _quantityPerUnit;
        private decimal _unitPrice;
        private int _unitsInStock;
        private int _unitsOnOrder;
        private int _reorderLevel;
        private bool _discontinued;

        private string _comments;

        private DateTime _expirationDate;

        public string Comments
        {
            get
            {
                return this._comments;
            }
            set
            {
                if (this._comments != value)
                {
                    this._comments = value;
                    OnPropertyChanged("Comments");
                }
            }
        }

        public int ProductID
        {
            get
            {
                return this._productId;
            }
            set
            {
                if (this._productId != value)
                {
                    this._productId = value;
                    OnPropertyChanged("ProductID");
                }
            }
        }

        public string ProductName
        {
            get
            {
                return this._productName;
            }
            set
            {
                if (this._productName != value)
                {
                    this._productName = value;
                    OnPropertyChanged("ProductName");
                }
            }
        }

        public int CategoryID
        {
            get
            {
                return this._categoryId;
            }
            set
            {
                if (this._categoryId != value)
                {
                    this._categoryId = value;
                    OnPropertyChanged("CategoryID");
                }
            }
        }

        public string QuantityPerUnit
        {
            get
            {
                return this._quantityPerUnit;
            }
            set
            {
                if (this._quantityPerUnit != value)
                {
                    this._quantityPerUnit = value;
                    OnPropertyChanged("QuantityPerUnit");
                }
            }
        }

        public decimal UnitPrice
        {
            get
            {
                return this._unitPrice;
            }
            set
            {
                if (value < 0)
                    throw new Exception("Negative numbers are not allowed.");

                this._unitPrice = value;
                OnPropertyChanged("UnitPrice");
            }
        }

        public int UnitsInStock
        {
            get
            {
                return this._unitsInStock;
            }
            set
            {
                if (value < 0)
                    throw new Exception("Negative numbers are not allowed.");

                this._unitsInStock = value;
                OnPropertyChanged("UnitsInStock");
            }
        }

        public int UnitsOnOrder
        {
            get
            {
                return this._unitsOnOrder;
            }
            set
            {
                if (this._unitsOnOrder != value)
                {
                    this._unitsOnOrder = value;
                    OnPropertyChanged("UnitsOnOrder");
                }
            }
        }

        public int ReorderLevel
        {
            get
            {
                return this._reorderLevel;
            }
            set
            {
                if (this._reorderLevel != value)
                {
                    this._reorderLevel = value;
                    OnPropertyChanged("ReorderLevel");
                }
            }
        }

        public DateTime ExpirationDate
        {
            get
            {
                return this._expirationDate;
            }
            set
            {
                if (this._expirationDate != value)
                {
                    this._expirationDate = value;
                    OnPropertyChanged("ExpirationDate");
                }
            }
        }

        public bool Discontinued
        {
            get
            {
                return this._discontinued;
            }
            set
            {
                if (this._discontinued != value)
                {
                    this._discontinued = value;
                    OnPropertyChanged("Discontinued");
                }
            }
        }
    }

    public class DataUtil
    {
        private static ObservableCollection<Category> _categories;
        private static ObservableCollection<Product> _products;
        private static ObservableCollection<Category> _categoriesAndProducts;
        private static ObservableCollection<Product> _fewerProducts;

        private static ObservableCollection<Category> CreateCategories()
        {
            return new ObservableCollection<Category>
{
	new Category
	{
		CategoryID = 1,
		CategoryName = "Beverages",
		Description = "Soft drinks, coffees, teas, beers, and ales"
	},
			
	new Category
	{
		CategoryID = 2,
		CategoryName = "Condiments",
		Description = "Sweet and savory sauces, relishes, spreads, and seasonings"
	},
			
	new Category
	{
		CategoryID = 3,
		CategoryName = "Confections",
		Description = "Desserts, candies, and sweet breads",
	},

	new Category
	{
		CategoryID = 4,
		CategoryName = "Dairy Products",
		Description = "Cheeses"
	},

	new Category
	{
		CategoryID = 5,
		CategoryName = "Grains/Cereals",
		Description = "Breads, crackers, pasta, and cereal",
	},

	new Category
	{
		CategoryID = 6,
		CategoryName = "Meat/Poultry",
		Description = "Prepared meats",
	},

	new Category
	{
		CategoryID = 7,
		CategoryName = "Produce",
		Description = "Dried fruit and bean curd",
	},

	new Category
	{
		CategoryID = 8,
		CategoryName = "Seafood",
		Description = "Seaweed and fish",
	}
};
        }

        private static ObservableCollection<Product> CreateProducts()
        {
            return new ObservableCollection<Product>
{
	new Product
	{
		ProductID = 1,
		ProductName = "Chai",
		CategoryID = 1,
		QuantityPerUnit = "10 boxes x 20 bags",
		UnitPrice = 18.0000m,
		UnitsInStock = 39,
		UnitsOnOrder = 0,
		ReorderLevel = 10,
		Discontinued = false
	},

	new Product
	{
		ProductID = 2,
		ProductName = "Chang",
		CategoryID = 1,
		QuantityPerUnit = "24 - 12 oz bottles",
		UnitPrice = 19.0000m,
		UnitsInStock = 17,
		UnitsOnOrder = 40,
		ReorderLevel = 25,
		Discontinued = false
	},
			
	new Product
	{
		ProductID = 24,
		ProductName = "Guaraná Fantástica",
		CategoryID = 1,
		QuantityPerUnit = "12 - 355 ml cans",
		UnitPrice = 4.5000m,
		UnitsInStock = 20,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = true
	},
			
	new Product
	{
		ProductID = 77,
		ProductName = "Original Frankfurter grüne Soße",
		CategoryID = 2,
		QuantityPerUnit = "12 boxes",
		UnitPrice = 13.0000m,
		UnitsInStock = 32,
		UnitsOnOrder = 0,
		ReorderLevel = 15,
		Discontinued = false
	},

	new Product
	{
		ProductID = 61,
		ProductName = "Sirop d'érable",
		CategoryID = 2,
		QuantityPerUnit = "24 - 500 ml bottles",
		UnitPrice = 28.5000m,
		UnitsInStock = 113,
		UnitsOnOrder = 0,
		ReorderLevel = 25,
		Discontinued = false
	},

	new Product
	{
		ProductID = 63,
		ProductName = "Vegie-spread",
		CategoryID = 2,
		QuantityPerUnit = "15 - 625 g jars",
		UnitPrice = 43.9000m,
		UnitsInStock = 24,
		UnitsOnOrder = 0,
		ReorderLevel = 5,
		Discontinued = false
	},

	new Product
	{
		ProductID = 16,
		ProductName = "Pavlova",
		CategoryID = 3,
		QuantityPerUnit = "32 - 500 g boxes",
		UnitPrice = 17.4500m,
		UnitsInStock = 29,
		UnitsOnOrder = 0,
		ReorderLevel = 10,
		Discontinued = false
	},

	new Product
	{
		ProductID = 19,
		ProductName = "Teatime Chocolate Biscuits",
		CategoryID = 3,
		QuantityPerUnit = "10 boxes x 12 pieces",
		UnitPrice = 9.2000m,
		UnitsInStock = 25,
		UnitsOnOrder = 0,
		ReorderLevel = 5,
		Discontinued = false
	},

	new Product
	{
		ProductID = 20,
		ProductName = "Sir Rodney's Marmalade",
		CategoryID = 3,
		QuantityPerUnit = "30 gift boxes",
		UnitPrice = 81.0000m,
		UnitsInStock = 40,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = false
	},

	new Product
	{
		ProductID = 69,
		ProductName = "Gudbrandsdalsost",
		CategoryID = 4,
		QuantityPerUnit = "10 kg pkg.",
		UnitPrice = 36.0000m,
		UnitsInStock = 26,
		UnitsOnOrder = 0,
		ReorderLevel = 15,
		Discontinued = false
	},

	new Product
	{
		ProductID = 71,
		ProductName = "Flotemysost",
		CategoryID = 4,
		QuantityPerUnit = "10 - 500 g pkgs.",
		UnitPrice = 21.5000m,
		UnitsInStock = 26,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = false
	},

	new Product
	{
		ProductID = 72,
		ProductName = "Mozzarella di Giovanni",
		CategoryID = 4,
		QuantityPerUnit = "24 - 200 g pkgs.",
		UnitPrice = 34.8000m,
		UnitsInStock = 14,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = false
	},
	new Product
	{
		ProductID = 22,
		ProductName = "Gustaf's Knäckebröd",
		CategoryID = 5,
		QuantityPerUnit = "24 - 500 g pkgs.",
		UnitPrice = 21.0000m,
		UnitsInStock = 104,
		UnitsOnOrder = 0,
		ReorderLevel = 25,
		Discontinued = false
	},

	new Product
	{
		ProductID = 23,
		ProductName = "Tunnbröd",
		CategoryID = 5,
		QuantityPerUnit = "12 - 250 g pkgs.",
		UnitPrice = 9.0000m,
		UnitsInStock = 61,
		UnitsOnOrder = 0,
		ReorderLevel = 25,
		Discontinued = false
	},

	new Product
	{
		ProductID = 53,
		ProductName = "Perth Pasties",
		CategoryID = 6,
		QuantityPerUnit = "48 pieces",
		UnitPrice = 32.8000m,
		UnitsInStock = 0,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = true
	},

	new Product
	{
		ProductID = 54,
		ProductName = "Tourtière",
		CategoryID = 6,
		QuantityPerUnit = "16 pies",
		UnitPrice = 7.4500m,
		UnitsInStock = 21,
		UnitsOnOrder = 0,
		ReorderLevel = 10,
		Discontinued = false
	},

	new Product
	{
		ProductID = 55,
		ProductName = "Pâté chinois",
		CategoryID = 6,
		QuantityPerUnit = "24 boxes x 2 pies",
		UnitPrice = 24.0000m,
		UnitsInStock = 115,
		UnitsOnOrder = 0,
		ReorderLevel = 20,
		Discontinued = false
	},

	new Product
	{
		ProductID = 28,
		ProductName = "Rössle Sauerkraut",
		CategoryID = 7,
		QuantityPerUnit = "25 - 825 g cans",
		UnitPrice = 45.6000m,
		UnitsInStock = 26,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = true
	},

	new Product
	{
		ProductID = 7,
		ProductName = "Uncle Bob's Organic Dried Pears",
		CategoryID = 7,
		QuantityPerUnit = "12 - 1 lb pkgs.",
		UnitPrice = 30.0000m,
		UnitsInStock = 15,
		UnitsOnOrder = 0,
		ReorderLevel = 10,
		Discontinued = false
	},

	new Product
	{
		ProductID = 14,
		ProductName = "Tofu",
		CategoryID = 7,
		QuantityPerUnit = "40 - 100 g pkgs.",
		UnitPrice = 23.2500m,
		UnitsInStock = 35,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = false
	},

	new Product
	{
		ProductID = 45,
		ProductName = "Rogede sild",
		CategoryID = 8,
		QuantityPerUnit = "1k pkg.",
		UnitPrice = 9.5000m,
		UnitsInStock = 5,
		UnitsOnOrder = 70,
		ReorderLevel = 15,
		Discontinued = false
	},

	new Product
	{
		ProductID = 46,
		ProductName = "Spegesild",
		CategoryID = 8,
		QuantityPerUnit = "4 - 450 g glasses",
		UnitPrice = 12.0000m,
		UnitsInStock = 95,
		UnitsOnOrder = 0,
		ReorderLevel = 0,
		Discontinued = false
	},

	new Product
	{
		ProductID = 58,
		ProductName = "Escargots de Bourgogne",
		CategoryID = 8,
		QuantityPerUnit = "24 pieces",
		UnitPrice = 13.2500m,
		UnitsInStock = 62,
		UnitsOnOrder = 0,
		ReorderLevel = 20,
		Discontinued = false
	}
};
        }
        private static ObservableCollection<Product> CreateFewerProducts()
        {
            return new ObservableCollection<Product>
            {
	            new Product
	            {
		            ProductID = 1,
		            ProductName = "Chai",
		            CategoryID = 1,
		            QuantityPerUnit = "10 boxes x 20 bags",
		            UnitPrice = 18.0000m,
		            UnitsInStock = 39,
		            UnitsOnOrder = 0,
		            ReorderLevel = 10,
		            Discontinued = false
	            },

	            new Product
	            {
		            ProductID = 2,
		            ProductName = "Chang",
		            CategoryID = 1,
		            QuantityPerUnit = "24 - 12 oz bottles",
		            UnitPrice = 19.0000m,
		            UnitsInStock = 17,
		            UnitsOnOrder = 40,
		            ReorderLevel = 25,
		            Discontinued = false
	            },
			
	            new Product
	            {
		            ProductID = 24,
		            ProductName = "Guaraná Fantástica",
		            CategoryID = 1,
		            QuantityPerUnit = "12 - 355 ml cans",
		            UnitPrice = 4.5000m,
		            UnitsInStock = 20,
		            UnitsOnOrder = 0,
		            ReorderLevel = 0,
		            Discontinued = true
	            },
			
	            new Product
	            {
		            ProductID = 77,
		            ProductName = "Original Frankfurter grüne Soße",
		            CategoryID = 2,
		            QuantityPerUnit = "12 boxes",
		            UnitPrice = 13.0000m,
		            UnitsInStock = 32,
		            UnitsOnOrder = 0,
		            ReorderLevel = 15,
		            Discontinued = false
	            },

	            new Product
	            {
		            ProductID = 61,
		            ProductName = "Sirop d'érable",
		            CategoryID = 2,
		            QuantityPerUnit = "24 - 500 ml bottles",
		            UnitPrice = 28.5000m,
		            UnitsInStock = 113,
		            UnitsOnOrder = 0,
		            ReorderLevel = 25,
		            Discontinued = false
	            },

	            new Product
	            {
		            ProductID = 63,
		            ProductName = "Vegie-spread",
		            CategoryID = 2,
		            QuantityPerUnit = "15 - 625 g jars",
		            UnitPrice = 43.9000m,
		            UnitsInStock = 24,
		            UnitsOnOrder = 0,
		            ReorderLevel = 5,
		            Discontinued = false
	            },
            };
        }

        private static ObservableCollection<Category> CreateCategoriesAndProducts()
        {
            ObservableCollection<Category> retVal = CreateCategories();

            ObservableCollection<Product> tempProducts = CreateProducts();

            Category parentCategory = null;

            foreach (Product p in tempProducts)
            {
                if (parentCategory == null || parentCategory.CategoryID != p.CategoryID)
                {
                    foreach (Category category in retVal)
                    {
                        if (category.CategoryID == p.CategoryID)
                        {
                            parentCategory = category;
                        }
                    }
                }

                parentCategory.Products.Add(p);
            }

            return retVal;
        }

        public static ObservableCollection<Category> Categories
        {
            get
            {
                if (_categories == null)
                    _categories = CreateCategories();

                return _categories;
            }
        }

        public static ObservableCollection<Product> Products
        {
            get
            {
                if (_products == null)
                    _products = CreateProducts();

                return _products;
            }
        }

        public static ObservableCollection<Product> FewerProducts
        {
            get
            {
                if (_fewerProducts == null)
                    _fewerProducts = CreateFewerProducts();

                return _fewerProducts;
            }
        }

        public static ObservableCollection<Category> CategoriesAndProducts
        {
            get
            {
                if (_categoriesAndProducts == null)
                    _categoriesAndProducts = CreateCategoriesAndProducts();

                return _categoriesAndProducts;
            }
        }
    }
}
