﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Json;
using Infragistics.Controls.Grids;

namespace SilverlightApplication1
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            string jsonString = "[{\"Name\":\"John Doe\", \"Email\":\"johnd@hotmail.com\", \"ID\":1},{\"Name\":\"Mary Doe\", \"Email\":\"maryd@hotmail.com\", \"ID\":2}]";

            JsonValue result =  JsonValue.Parse(jsonString);
            List<Dictionary<string, string>> datasource = new List<Dictionary<string, string>>();
            
            foreach (JsonValue value in result)
            {
                Dictionary<string, string> rowData = new Dictionary<string, string>();

                foreach (KeyValuePair<string, JsonValue> v in value)
                {
                    if (xamGrid1.Columns["[" + v.Key + "]"] == null)
                        xamGrid1.Columns.Add(new TextColumn { Key = "[" + v.Key + "]", HeaderText = v.Key });

                    rowData.Add(v.Key, StripQuotes(v.Value.ToString()));
                }

                datasource.Add(rowData);
            }

            xamGrid1.ItemsSource = datasource;
        }

        string StripQuotes(string jsonValue)
        {
            if (jsonValue[0] == '\"' && jsonValue[jsonValue.Length - 1] == '\"')
            {
                jsonValue = jsonValue.Remove(jsonValue.Length - 1, 1);
                jsonValue = jsonValue.Remove(0, 1);
                return jsonValue;
            }

            return jsonValue;
        }
    }
}
