﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Web;

namespace WebDataGrid_sample
{

    public class Item : INotifyPropertyChanged
    {
        private string name;
        private int id;
        private double weight;
        //private DateTime? shipping;
        private Nullable<System.DateTime> shipping;

        public Item()
        { }

        public Item(string name, int id, double weight, Nullable<System.DateTime> shipping)
        {
            this.Name = name;
            this.Id = id;
            this.Weight = weight;
            this.Shipping = shipping;
        }

        public string Name
        {
            get { return name; }
            set
            {
                name = value;
                NotifyPropertyChanged("Name");
            }
        }

        public int Id
        {
            get { return id; }
            set
            {
                id = value;
                NotifyPropertyChanged("Id");
            }
        }

        public double Weight
        {
            get { return weight; }
            set
            {
                weight = value;
                NotifyPropertyChanged("Weight");
            }
        }

        //public DateTime? Shipping
        //{
        //    get { return shipping; }
        //    set
        //    {
        //        shipping = value;
        //        NotifyPropertyChanged("Shipping");
        //    }
        //}

        public Nullable<System.DateTime> Shipping
        {
            get { return shipping; }
            set
            {
                shipping = value;
                NotifyPropertyChanged("Shipping");
            }
        }

        #region Notify Property Changed

        public event PropertyChangedEventHandler PropertyChanged;
        private void NotifyPropertyChanged(string propertyName = "")
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        #endregion // Notify Property Changed 

    }

}