﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WebForm1.aspx.cs" Inherits="WebDataGrid_sample.WebForm1" %>

<%@ Register Assembly="Infragistics45.Web.v17.2, Version=17.2.20172.2019, Culture=neutral, PublicKeyToken=7dd5c3163f2cd0cb" Namespace="Infragistics.Web.UI.GridControls" TagPrefix="ig" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>WebDataGrid Sample</title>
    <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
    <script src="http://code.jquery.com/ui/1.11.1/jquery-ui.min.js"></script>

    <script>
        function RowEditing_EnteringEditMode(sender, e) {
            // Allow Editing only for row with index==1.
            //
            var editingRow = e.getCells()[0].getCell().get_row();
            if (editingRow.get_index() !== 1) {
                e.set_cancel(true);
            }
        }

        function RowEditing_ExitedEditMode(sender, e) {
            var grid = $find("dataGrid");
            grid.get_behaviors().get_editingCore().commit();
        }
    </script>
</head>

<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

        <ig:WebDataGrid ID="dataGrid" runat="server" Width="700px" Height="400px" AutoGenerateColumns="false"
            DataKeyFields="Id"
            OnRowAdding="dataGrid_RowAdding"
            OnRowUpdating="dataGrid_RowUpdating">

            <Columns>
                <ig:BoundDataField Key="Name" Header-Text="The Name" DataType="System.String" />
                <ig:BoundDataField Key="Id" Header-Text="The Id" DataType="System.Int32" />
                <ig:BoundDataField Key="Weight" Header-Text="The Weight" DataType="System.Double" />
                <ig:BoundDataField Key="Shipping" Header-Text="The Shipping" DataType="System.DateTime" />
            </Columns>

            <Behaviors>
                <ig:EditingCore AutoCRUD="true">
                    <Behaviors>
                        <ig:RowAdding Enabled="true"></ig:RowAdding>
                        <ig:RowEditing Enabled="true"
                            RowEditingClientEvents-EnteringEditMode="RowEditing_EnteringEditMode"
                            RowEditingClientEvents-ExitedEditMode="RowEditing_ExitedEditMode">
                        </ig:RowEditing>
                    </Behaviors>
                </ig:EditingCore>
                <ig:Activation></ig:Activation>
            </Behaviors>
        </ig:WebDataGrid>

        <div>
            <asp:Button runat="server" ID="btn" OnClick="btn_Click" Text="Disable editing of grid" />
        </div>

    </form>
</body>

</html>
