﻿using Infragistics.Web.UI.GridControls;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace WebDataGrid_sample
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        public List<Item> TestItems { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
            //Create a SessionStorage at the server to persist the DataTable changes
            if (Session["data"] == null)
            {
                Session["data"] = MakeTable();
            }

            dataGrid.DataSource = (DataTable)Session["data"];
        }

        private DataTable MakeTable()
        {
            DataTable table = new DataTable();

            table.Columns.Add("Name", typeof(string));
            table.Columns.Add("Id", typeof(Int32));
            table.Columns.Add("Weight", typeof(double));
            table.Columns.Add("Shipping", typeof(DateTime));

            // Make the ID PrimaryKeyColumns collection and add 1 primary key column. Primary key is a requiered for using CRUD operations
            DataColumn[] PrimaryKeyColumns = new DataColumn[1];
            PrimaryKeyColumns[0] = table.Columns["Id"];
            table.PrimaryKey = PrimaryKeyColumns;

            table.Rows.Add("Item 01", "111", "1000", DateTime.Today);
            table.Rows.Add("Item 02", "222", "2000", DateTime.Today.AddDays(1));
            table.Rows.Add("Item 03", "333", "3000", DateTime.Today.AddDays(2));
            table.Rows.Add("Item 04", "444", "4000", DateTime.Today.AddDays(3));

            return table;
        }

        protected void dataGrid_RowAdding(object sender, RowAddingEventArgs e)
        {

        }

        protected void dataGrid_RowUpdating(object sender, RowUpdatingEventArgs e)
        {

        }

        protected void btn_Click(object sender, EventArgs e)
        {
            GridRecord row = null;
            if (dataGrid.Behaviors.Activation.ActiveCell != null)
                row = dataGrid.Behaviors.Activation.ActiveCell.Row;
            dataGrid.Behaviors.EditingCore.Behaviors.RowEditing.Enabled = false;
        }
    }
}