﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WinCombo_MultiSelect_CS
{
    public partial class Form1 : Form
    {
        private DataTable dt;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.CreateData();

            this.ultraCombo1.CheckedListSettings.CheckStateMember = "Selected";
            this.ultraCombo1.CheckedListSettings.EditorValueSource = Infragistics.Win.EditorWithComboValueSource.CheckedItems;
            this.ultraCombo1.CheckedListSettings.ItemCheckArea = Infragistics.Win.ItemCheckArea.Item;
            this.ultraCombo1.DisplayMember = "Name";
            this.ultraCombo1.ValueMember = "Key";

            this.ultraCombo1.InitializeLayout += UltraCombo1_InitializeLayout;
            this.ultraCombo1.SetDataBinding(this.dt, null);
        }

        private void UltraCombo1_InitializeLayout(object sender, Infragistics.Win.UltraWinGrid.InitializeLayoutEventArgs e)
        {
            var layout = e.Layout;
            var band = layout.Bands[0];
            var ov = layout.Override;            

            var checkBoxColumn = band.Columns.Add("Selected");
            checkBoxColumn.DataType = typeof(bool);
            checkBoxColumn.Header.VisiblePosition = 0;
        }

        private void CreateData()
        {
            this.dt = new DataTable();
            dt.Columns.Add("Key", typeof(int));
            dt.Columns.Add("Name", typeof(string));

            dt.Rows.Add(new object[] { 0, "Apple" });
            dt.Rows.Add(new object[] { 1, "Banana" });
            dt.Rows.Add(new object[] { 2, "Cherry" });
            dt.Rows.Add(new object[] { 3, "Grape" });
            dt.Rows.Add(new object[] { 4, "Watermelon" });
            dt.AcceptChanges();
        }

        private void btnShowSelectedItem_Click(object sender, EventArgs e)
        {
            var selectedValue = this.ultraCombo1.Value;
            if (selectedValue == null || selectedValue is DBNull)
            {
                this.textBox1.Text = "(Null)";
                return;
            }

            var selectedItems = selectedValue as List<object>;
            if (null != selectedItems)
            {
                var sb = new StringBuilder();
                sb.AppendLine(string.Format("Selected Items: {0}", selectedItems.Count));
                foreach (object selectedItem in selectedItems)
                {
                    sb.AppendLine(selectedItem.ToString());
                }

                this.textBox1.Text = sb.ToString();
                return;
            }

            this.textBox1.Text = "Unexpected Value";            
        }
    }
}
