﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApp50
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.ultraGrid1.Error += this.UltraGrid1_Error;

            var dt = DummyDataCreator.GetData(10, new Type[] { typeof(string), typeof(int) });
            this.ultraGrid1.DataSource = dt;
        }

        private void UltraGrid1_Error(object sender, Infragistics.Win.UltraWinGrid.ErrorEventArgs e)
        {
            if (null != e.MultiCellOperationErrorInfo)
            {
                if (e.MultiCellOperationErrorInfo.ErrorCell.Column.Key == "Key" &&
                    e.MultiCellOperationErrorInfo.Operation == Infragistics.Win.UltraWinGrid.MultiCellOperation.Paste &&
                    e.MultiCellOperationErrorInfo.CanContinueWithRemainingCells)
                {
                    e.MultiCellOperationErrorInfo.Action = Infragistics.Win.UltraWinGrid.MultiCellOperationErrorInfo.ErrorAction.Continue;
                    e.Cancel = true;
                }
            }
        }

        private void ultraGrid1_InitializeLayout(object sender, Infragistics.Win.UltraWinGrid.InitializeLayoutEventArgs e)
        {
            var layout = e.Layout;
            var band = layout.Bands[0];
            var ov = layout.Override;

            ov.CellClickAction = Infragistics.Win.UltraWinGrid.CellClickAction.CellSelect;

            ov.AllowAddNew = Infragistics.Win.UltraWinGrid.AllowAddNew.TemplateOnBottom;
            ov.AllowMultiCellOperations = Infragistics.Win.UltraWinGrid.AllowMultiCellOperation.All;
        }
    }
}
