﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using igGridSample.Models;
using Infragistics.Web.Mvc;

namespace igGridSample.Controllers
{
    public class HomeController : Controller
    {
        //
        // GET: /Home/
        private static List<Product> products = GetProducts();

        public ActionResult Index()
        {
            return View(products.AsQueryable());
        }

        private static List<Product> GetProducts()
        {
            List<Product> products = new List<Product>()
            {
                new Product() { ProductID = 1, Name = "Adjustable Race", ProductNumber = "AR-5381", ReleaseDate = new DateTime(2012, 01, 01) },
                new Product() { ProductID = 2, Name = "Bearing Ball", ProductNumber = "BA-8327" },
                new Product() { ProductID = 3, Name = "BB Ball Bearing", ProductNumber = "BE-2349" },
                new Product() { ProductID = 4, Name = "Headset Ball Bearings", ProductNumber = "BE-2908" },
                new Product() { ProductID = 316, Name = "Blade", ProductNumber = "BL-2036" },
                new Product() { ProductID = 317, Name = "LL Crankarm", ProductNumber = "CA-5965" },
                new Product() { ProductID = 318, Name = "ML Crankarm", ProductNumber = "CA-6738" },
                new Product() { ProductID = 319, Name = "HL Crankarm", ProductNumber = "CA-7457" },
                new Product() { ProductID = 320, Name = "Chainring Bolts", ProductNumber = "CB-2903" },
                new Product() { ProductID = 321, Name = "Chainring Nut", ProductNumber = "CN-6137" }
            };

            return products;
        }
        [GridDataSourceAction]
        public ActionResult GetData()
        {
            return View(products.AsQueryable());
        }

        public ActionResult SaveData()
        {
            GridModel m = new GridModel();
            List<Transaction<Product>> transactions = m.LoadTransactions<Product>(HttpContext.Request.Form["ig_transactions"]);
            List<Ids> ids = new List<Ids>();

            foreach (Transaction<Product> t in transactions)
            {
                if (t.type == "newrow")
                {
                    // usually your repository pattern Add mehtod will return the new id
                    products.Add(t.row);
                    // here we simulate the generation of the new id
                    ids.Add(new Ids() { OldId = t.row.ProductID, NewId = t.row.ProductID + 10 });

                }
                else if (t.type == "deleterow")
                {
                    var product = (from p in products
                                   where p.ProductID == Int32.Parse(t.rowId)
                                   select p).Single();

                    //remove product
                    products.Remove(product);
                }
                else if (t.type == "row")
                {
                    var product = (from p in products
                                   where p.ProductID == Int32.Parse(t.rowId)
                                   select p).Single();

                    if (t.row.Name != null)
                    {
                        product.Name = t.row.Name;
                    }
                    if (t.row.ProductNumber != null)
                    {
                        product.ProductNumber = t.row.ProductNumber;
                    }
                    if (t.row.ReleaseDate != null)
                    {
                        product.ReleaseDate = t.row.ReleaseDate;
                    }
                }
            }

            JsonResult result = new JsonResult();
            Dictionary<string, object> response = new Dictionary<string, object>();
            response.Add("Success", true);
            response.Add("ids", ids);
            result.Data = response;
            return result;
            
        }
    }
}
