import { Component, Input, OnInit, Pipe, PipeTransform } from '@angular/core';
import { Card } from 'src/app/card.blueprint';

@Component({
  selector: 'app-card',
  styleUrls: ['./card.component.scss'],
  templateUrl: './card.component.html',
})
export class CardComponent {
  @Input() public card: Card | any;
  public horizontal = true;

  public counter = 124;
  public initialCounter = 124;
  public showTxt = 'Show more';

  public toggle(): void {
    if (this.counter === 124) {
      this.counter = this.card.content.length;
      this.showTxt = 'Show less';
    } else {
      this.counter = 124;
      this.showTxt = 'Show more';
    }
  }
}

@Pipe({
  name: 'truncate',
})
export class TruncatePipe implements PipeTransform {
  transform(value: string): string {
      if (value.length < 124) {
          return value;
      }
    return value.substring(0, 110) + '... ';
  }
}